/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.read;

import java.io.IOException;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.read.AbstractZipReader;
import software.coley.lljzip.format.read.SimpleZipPartAllocator;
import software.coley.lljzip.format.read.ZipPartAllocator;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.ByteDataUtil;

public class NaiveLocalFileZipReader
extends AbstractZipReader {
    public NaiveLocalFileZipReader() {
        super(new SimpleZipPartAllocator());
    }

    public NaiveLocalFileZipReader(@Nonnull ZipPartAllocator allocator) {
        super(allocator);
    }

    @Override
    public void read(@Nonnull ZipArchive zip, @Nonnull ByteData data) throws IOException {
        long localFileOffset = -1L;
        while ((localFileOffset = ByteDataUtil.indexOfQuad(data, localFileOffset + 1L, 67324752)) >= 0L) {
            LocalFileHeader file = this.newLocalFileHeader();
            file.read(data, localFileOffset);
            zip.addPart(file);
            this.postProcessLocalFileHeader(file);
        }
    }
}

