/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.atomic.AtomicBoolean;
import software.coley.lljzip.util.BufferData;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.UnsafeMappedFile;

public class FileMapUtil {
    private static final Method MAP;
    private static final Method UNMAP;
    private static final boolean OLD_MAP;

    public static ByteData map(Path path) throws IOException {
        if (MAP == null) {
            long size = Files.size(path);
            if (size <= Integer.MAX_VALUE) {
                try (FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);){
                    long length = fc.size();
                    MappedByteBuffer buffer = fc.map(FileChannel.MapMode.READ_ONLY, 0L, length);
                    buffer.order(ByteOrder.LITTLE_ENDIAN);
                    BufferData bufferData = BufferData.wrap(buffer);
                    return bufferData;
                }
            }
            throw new IllegalStateException("Cannot map more than 2GB of data in locked up environment");
        }
        try (FileChannel fc = FileChannel.open(path, StandardOpenOption.READ);){
            UnsafeMappedFile mappedFile;
            long address;
            long length = fc.size();
            try {
                address = OLD_MAP ? ((Long)MAP.invoke((Object)fc, 0, 0L, length)).longValue() : ((Long)MAP.invoke((Object)fc, 0, 0L, length, false)).longValue();
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                throw new IllegalStateException("Could not invoke map0", ex);
            }
            UnsafeMappedFile unsafeMappedFile = mappedFile = new UnsafeMappedFile(address, length, () -> {
                try {
                    UNMAP.invoke(null, address, length);
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    throw new InternalError(ex);
                }
            }, new AtomicBoolean());
            return unsafeMappedFile;
        }
    }

    static {
        Method unmap;
        Method map;
        boolean oldMap;
        block8: {
            Class<?> c;
            oldMap = false;
            map = null;
            unmap = null;
            try {
                c = Class.forName("sun.nio.ch.FileChannelImpl");
            }
            catch (ClassNotFoundException ignored) {
                break block8;
            }
            try {
                map = c.getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException ex) {
                try {
                    map = c.getDeclaredMethod("map0", Integer.TYPE, Long.TYPE, Long.TYPE);
                    oldMap = true;
                }
                catch (NoSuchMethodException ignored) {
                    break block8;
                }
            }
            try {
                map.setAccessible(true);
                unmap = c.getDeclaredMethod("unmap0", Long.TYPE, Long.TYPE);
                unmap.setAccessible(true);
            }
            catch (Exception ex) {
                map = null;
                unmap = null;
            }
        }
        MAP = map;
        UNMAP = unmap;
        OLD_MAP = oldMap;
    }
}

