/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util;

import java.util.Comparator;
import java.util.Optional;
import software.coley.lljzip.format.model.AbstractZipFileHeader;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipPart;

public class NameComparator
implements Comparator<ZipPart> {
    private final Comparator<ZipPart> fallback;

    public NameComparator(Comparator<ZipPart> fallback) {
        this.fallback = fallback;
    }

    @Override
    public int compare(ZipPart o1, ZipPart o2) {
        if (o1 instanceof LocalFileHeader && o2 instanceof LocalFileHeader) {
            LocalFileHeader header1 = (LocalFileHeader)o1;
            LocalFileHeader header2 = (LocalFileHeader)o2;
            String name1 = Optional.ofNullable(header1.getLinkedDirectoryFileHeader()).map(AbstractZipFileHeader::getFileNameAsString).orElse(header1.getFileNameAsString());
            String name2 = Optional.ofNullable(header2.getLinkedDirectoryFileHeader()).map(AbstractZipFileHeader::getFileNameAsString).orElse(header2.getFileNameAsString());
            return name1.compareTo(name2);
        }
        if (o1 instanceof CentralDirectoryFileHeader && o2 instanceof CentralDirectoryFileHeader) {
            CentralDirectoryFileHeader header1 = (CentralDirectoryFileHeader)o1;
            CentralDirectoryFileHeader header2 = (CentralDirectoryFileHeader)o2;
            String name1 = header1.getFileNameAsString();
            String name2 = header2.getFileNameAsString();
            return name1.compareTo(name2);
        }
        return this.fallback.compare(o1, o2);
    }
}

