/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.UnsafeUtil;
import sun.misc.Unsafe;

final class UnsafeMappedFile
implements ByteData {
    private static final boolean SWAP = ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN;
    private static final Unsafe UNSAFE = UnsafeUtil.get();
    private final AtomicBoolean cleaned;
    private final long address;
    private final long end;
    private final Runnable deallocator;
    private final Object attachment;

    private UnsafeMappedFile(Object attachment, long address, long end, AtomicBoolean cleaned) {
        this.attachment = attachment;
        this.address = address;
        this.end = end;
        this.cleaned = cleaned;
        this.deallocator = null;
    }

    UnsafeMappedFile(long address, long length, Runnable deallocator, AtomicBoolean cleaned) {
        this.address = address;
        this.end = address + length;
        this.deallocator = deallocator;
        this.cleaned = cleaned;
        this.attachment = null;
    }

    @Override
    public int getInt(long position) {
        this.ensureOpen();
        return UnsafeMappedFile.swap(UNSAFE.getInt(this.validate(position)));
    }

    @Override
    public long getLong(long position) {
        this.ensureOpen();
        return UnsafeMappedFile.swap(UNSAFE.getLong(this.validate(position)));
    }

    @Override
    public short getShort(long position) {
        this.ensureOpen();
        return UnsafeMappedFile.swap(UNSAFE.getShort(this.validate(position)));
    }

    @Override
    public byte get(long position) {
        this.ensureOpen();
        return UNSAFE.getByte(this.validate(position));
    }

    @Override
    public void get(long position, byte[] buffer, int off, int len) {
        this.ensureOpen();
        long address = this.validate(position);
        if (address + (long)len > this.end) {
            throw new IllegalArgumentException();
        }
        UNSAFE.copyMemory(null, address, buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET + off, len);
    }

    @Override
    public void transferTo(OutputStream out, byte[] buffer) throws IOException {
        this.ensureOpen();
        int copyThreshold = buffer.length;
        long address = this.address;
        long remaining = this.end - address;
        while (remaining != 0L) {
            int length = (int)Math.min((long)copyThreshold, remaining);
            UNSAFE.copyMemory(null, address, buffer, Unsafe.ARRAY_BYTE_BASE_OFFSET, length);
            remaining -= (long)length;
            address += (long)length;
            out.write(buffer, 0, length);
        }
    }

    @Override
    public ByteData slice(long startIndex, long endIndex) {
        this.ensureOpen();
        if (startIndex > endIndex) {
            throw new IllegalArgumentException();
        }
        return new UnsafeMappedFile(this, this.validate(startIndex), this.validate(endIndex), this.cleaned);
    }

    @Override
    public long length() {
        this.ensureOpen();
        return this.end - this.address;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UnsafeMappedFile)) {
            return false;
        }
        UnsafeMappedFile that = (UnsafeMappedFile)o;
        if (this.address != that.address) {
            return false;
        }
        return this.end == that.end;
    }

    public int hashCode() {
        long address = this.address;
        int result = Long.hashCode(address);
        result = 31 * result + Long.hashCode(this.end - address);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.cleaned.get()) {
            UnsafeMappedFile unsafeMappedFile = this;
            synchronized (unsafeMappedFile) {
                if (this.cleaned.get()) {
                    return;
                }
                this.cleaned.set(true);
                Runnable deallocator = this.deallocator;
                if (deallocator != null) {
                    deallocator.run();
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.cleaned.get();
    }

    private void ensureOpen() {
        if (this.cleaned.get()) {
            throw new IllegalStateException("Cannot access data after close");
        }
    }

    private long validate(long position) {
        if (position < 0L) {
            throw new IllegalArgumentException();
        }
        if ((position += this.address) > this.end) {
            long diff = position - this.end;
            throw new IllegalArgumentException("positon beyond max bounds: " + position + " > " + this.end + " diff: " + diff);
        }
        return position;
    }

    private static long swap(long x) {
        if (SWAP) {
            return Long.reverseBytes(x);
        }
        return x;
    }

    private static int swap(int x) {
        if (SWAP) {
            return Integer.reverseBytes(x);
        }
        return x;
    }

    private static short swap(short x) {
        if (SWAP) {
            return (short)(x >> 8 & 0xFF | x << 8);
        }
        return x;
    }
}

