/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util.lazy;

import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.lazy.Lazy;

public class LazyByteData
extends Lazy<Supplier<ByteData>> {
    private ByteData value;

    public LazyByteData(@Nonnull Supplier<ByteData> lookup) {
        super(lookup);
    }

    @Nonnull
    public LazyByteData copy() {
        LazyByteData copy = new LazyByteData((Supplier)this.lookup);
        copy.id = this.id;
        if (this.set) {
            copy.set(this.value);
        }
        return copy;
    }

    public void set(@Nonnull ByteData value) {
        this.set = true;
        this.value = value;
    }

    @Nonnull
    public ByteData get() {
        if (!this.set) {
            this.value = (ByteData)((Supplier)this.lookup).get();
            this.set = true;
        }
        return this.value;
    }

    public String toString() {
        return this.id + " data[" + this.get().length() + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyByteData that = (LazyByteData)o;
        return Objects.equals(this.get(), that.get());
    }

    public int hashCode() {
        return Objects.hashCode(this.get());
    }
}

