/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util.lazy;

import java.util.function.IntSupplier;
import javax.annotation.Nonnull;
import software.coley.lljzip.util.lazy.Lazy;

public class LazyInt
extends Lazy<IntSupplier> {
    private int value;

    public LazyInt(@Nonnull IntSupplier lookup) {
        super(lookup);
    }

    @Nonnull
    public LazyInt copy() {
        LazyInt copy = new LazyInt((IntSupplier)this.lookup);
        copy.id = this.id;
        if (this.set) {
            copy.set(this.value);
        }
        return copy;
    }

    public LazyInt add(int value) {
        return new LazyInt(() -> value + ((IntSupplier)this.lookup).getAsInt());
    }

    public LazyInt add(@Nonnull LazyInt value) {
        return new LazyInt(() -> value.get() + ((IntSupplier)this.lookup).getAsInt());
    }

    public void set(int value) {
        this.set = true;
        this.value = value;
    }

    public int get() {
        if (!this.set) {
            this.value = ((IntSupplier)this.lookup).getAsInt();
            this.set = true;
        }
        return this.value;
    }

    public String toString() {
        return this.id + " " + this.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyInt lazyInt = (LazyInt)o;
        return this.get() == lazyInt.get();
    }

    public int hashCode() {
        return this.get();
    }
}

