/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.util.BufferData;
import software.coley.lljzip.util.NoopByteData;
import software.coley.lljzip.util.lazy.LazyByteData;
import software.coley.lljzip.util.lazy.LazyInt;
import software.coley.lljzip.util.lazy.LazyLong;

public class AdaptingLocalFileHeader
extends LocalFileHeader {
    private static final int BUFFER_SIZE = 2048;

    public AdaptingLocalFileHeader(@Nonnull ZipFile archive, @Nonnull ZipEntry entry) throws IOException {
        int read;
        InputStream inputStream = archive.getInputStream(entry);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        while ((read = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
        }
        byte[] entryData = outputStream.toByteArray();
        String entryName = entry.getName();
        byte[] extra = entry.getExtra();
        this.versionNeededToExtract = new LazyInt(() -> 0);
        this.generalPurposeBitFlag = new LazyInt(() -> 0);
        this.lastModFileTime = new LazyInt(() -> 0);
        this.lastModFileDate = new LazyInt(() -> 0);
        this.fileNameLength = new LazyInt(entryName::length);
        this.fileName = new LazyByteData(() -> BufferData.wrap(entryName.getBytes()));
        this.fileDataLength = new LazyLong(() -> entryData.length);
        this.fileData = new LazyByteData(() -> BufferData.wrap(entryData));
        this.compressionMethod = new LazyInt(() -> 0);
        this.uncompressedSize = new LazyLong(() -> entryData.length);
        this.compressedSize = new LazyLong(() -> entryData.length);
        this.crc32 = new LazyInt(() -> (int)entry.getCrc());
        if (extra != null) {
            this.extraFieldLength = new LazyInt(() -> extra.length);
            this.extraField = new LazyByteData(() -> BufferData.wrap(extra));
        } else {
            this.extraFieldLength = new LazyInt(() -> 0);
            this.extraField = new LazyByteData(() -> NoopByteData.INSTANCE);
        }
        this.data = NoopByteData.INSTANCE;
    }
}

