/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import java.util.Objects;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.PartType;
import software.coley.lljzip.format.model.ZipPart;
import software.coley.lljzip.format.model.ZipRead;
import software.coley.lljzip.util.BufferData;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.ByteDataUtil;

public class EndOfCentralDirectory
implements ZipPart,
ZipRead {
    private transient long offset = -1L;
    private int diskNumber;
    private int centralDirectoryStartDisk;
    private int centralDirectoryStartOffset;
    private int numEntries;
    private long centralDirectorySize;
    private long centralDirectoryOffset;
    private int zipCommentLength;
    private ByteData zipComment;
    private transient String zipCommentCache;

    @Nonnull
    public EndOfCentralDirectory copy() {
        EndOfCentralDirectory copy = new EndOfCentralDirectory();
        copy.offset = this.offset;
        copy.diskNumber = this.diskNumber;
        copy.centralDirectoryStartDisk = this.centralDirectoryStartDisk;
        copy.centralDirectoryStartOffset = this.centralDirectoryStartOffset;
        copy.numEntries = this.numEntries;
        copy.centralDirectorySize = this.centralDirectorySize;
        copy.centralDirectoryOffset = this.centralDirectoryOffset;
        copy.zipCommentLength = this.zipCommentLength;
        copy.zipComment = this.zipComment;
        copy.zipCommentCache = this.zipCommentCache;
        return copy;
    }

    @Override
    public void read(@Nonnull ByteData data, long offset) {
        this.offset = offset;
        this.diskNumber = ByteDataUtil.readWord(data, offset + 4L);
        this.centralDirectoryStartDisk = ByteDataUtil.readWord(data, offset + 6L);
        this.centralDirectoryStartOffset = ByteDataUtil.readWord(data, offset + 8L);
        this.numEntries = ByteDataUtil.readWord(data, offset + 10L);
        this.setCentralDirectorySize(ByteDataUtil.readQuad(data, offset + 12L));
        this.setCentralDirectoryOffset(ByteDataUtil.readQuad(data, offset + 16L));
        this.setZipCommentLength(ByteDataUtil.readWord(data, offset + 20L));
        this.zipComment = data.sliceOf(offset + 22L, this.zipCommentLength);
    }

    @Override
    public long length() {
        return 22L + this.zipComment.length();
    }

    @Override
    @Nonnull
    public PartType type() {
        return PartType.END_OF_CENTRAL_DIRECTORY;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    public int getDiskNumber() {
        return this.diskNumber;
    }

    public void setDiskNumber(int diskNumber) {
        this.diskNumber = diskNumber;
    }

    public int getCentralDirectoryStartDisk() {
        return this.centralDirectoryStartDisk;
    }

    public void setCentralDirectoryStartDisk(int centralDirectoryStartDisk) {
        this.centralDirectoryStartDisk = centralDirectoryStartDisk;
    }

    public int getCentralDirectoryStartOffset() {
        return this.centralDirectoryStartOffset;
    }

    public void setCentralDirectoryStartOffset(int centralDirectoryStartOffset) {
        this.centralDirectoryStartOffset = centralDirectoryStartOffset;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public void setNumEntries(int numEntries) {
        this.numEntries = numEntries;
    }

    public long getCentralDirectorySize() {
        return this.centralDirectorySize;
    }

    public void setCentralDirectorySize(long centralDirectorySize) {
        this.centralDirectorySize = centralDirectorySize & 0xFFFFFFFFL;
    }

    public long getCentralDirectoryOffset() {
        return this.centralDirectoryOffset;
    }

    public void setCentralDirectoryOffset(long centralDirectoryOffset) {
        this.centralDirectoryOffset = centralDirectoryOffset & 0xFFFFFFFFL;
    }

    public int getZipCommentLength() {
        return this.zipCommentLength;
    }

    public void setZipCommentLength(int zipCommentLength) {
        this.zipCommentLength = zipCommentLength & 0xFFFF;
    }

    public ByteData getZipComment() {
        return this.zipComment;
    }

    public void setZipComment(ByteData zipComment) {
        if (zipComment == null) {
            zipComment = BufferData.wrap(new byte[0]);
        }
        this.zipComment = zipComment;
    }

    public String getZipCommentAsString() {
        String zipCommentCache = this.zipCommentCache;
        if (zipCommentCache == null) {
            this.zipCommentCache = ByteDataUtil.toString(this.zipComment);
            return this.zipCommentCache;
        }
        return zipCommentCache;
    }

    public String toString() {
        return "EndOfCentralDirectory{offset=" + this.offset + ", diskNumber=" + this.diskNumber + ", centralDirectoryStartDisk=" + this.centralDirectoryStartDisk + ", centralDirectoryStartOffset=" + this.centralDirectoryStartOffset + ", numEntries=" + this.numEntries + ", centralDirectorySize=" + this.centralDirectorySize + ", centralDirectoryOffset=" + this.centralDirectoryOffset + ", zipCommentLength=" + this.zipCommentLength + ", zipComment='" + this.getZipCommentAsString() + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EndOfCentralDirectory that = (EndOfCentralDirectory)o;
        return this.diskNumber == that.diskNumber && this.centralDirectoryStartDisk == that.centralDirectoryStartDisk && this.centralDirectoryStartOffset == that.centralDirectoryStartOffset && this.numEntries == that.numEntries && this.centralDirectorySize == that.centralDirectorySize && this.centralDirectoryOffset == that.centralDirectoryOffset && this.zipCommentLength == that.zipCommentLength && this.zipComment.equals(that.zipComment);
    }

    public int hashCode() {
        return Objects.hash(this.diskNumber, this.centralDirectoryStartDisk, this.centralDirectoryStartOffset, this.numEntries, this.centralDirectorySize, this.centralDirectoryOffset, this.zipCommentLength, this.zipComment);
    }
}

