/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import java.util.NavigableSet;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.ByteDataUtil;
import software.coley.lljzip.util.lazy.LazyByteData;
import software.coley.lljzip.util.lazy.LazyLong;

public class JvmLocalFileHeader
extends LocalFileHeader {
    private NavigableSet<Long> offsets;
    private long relativeDataOffsetStart;
    private long relativeDataOffsetEnd;
    private boolean foundData;

    public void setOffsets(@Nonnull NavigableSet<Long> offsets) {
        this.offsets = offsets;
    }

    @Override
    public void read(@Nonnull ByteData data, long offset) {
        super.read(data, offset);
        long relativeDataOffsetStart = 30 + this.getFileNameLength() + this.getExtraFieldLength();
        Long absoluteDataOffsetEnd = this.offsets.ceiling(offset + relativeDataOffsetStart);
        if (absoluteDataOffsetEnd != null && (this.getGeneralPurposeBitFlag() & 8) == 8 && data.getInt(absoluteDataOffsetEnd = Long.valueOf(absoluteDataOffsetEnd - 12L)) == 134695760) {
            absoluteDataOffsetEnd = absoluteDataOffsetEnd - 4L;
        }
        long relativeDataOffsetEnd = absoluteDataOffsetEnd == null ? relativeDataOffsetStart : absoluteDataOffsetEnd - offset;
        this.relativeDataOffsetStart = relativeDataOffsetStart;
        this.relativeDataOffsetEnd = relativeDataOffsetEnd;
        this.fileDataLength = (LazyLong)new LazyLong(() -> relativeDataOffsetEnd - relativeDataOffsetStart).withId("fileDataLength");
        this.fileData = (LazyByteData)ByteDataUtil.readLazyLongSlice(data, offset, new LazyLong(() -> relativeDataOffsetStart), this.fileDataLength).withId("fileData");
        long size = this.fileDataLength.get();
        if (this.getCompressionMethod() == 0) {
            this.setUncompressedSize(size);
            this.setCompressedSize(size);
        } else {
            this.setCompressedSize(size);
        }
        this.foundData = size != 0L;
    }

    @Override
    public void adoptLinkedCentralDirectoryValues() {
        long fileDataLength;
        CentralDirectoryFileHeader directoryFileHeader = this.linkedDirectoryFileHeader;
        if (directoryFileHeader == null) {
            return;
        }
        this.versionNeededToExtract = this.linkedDirectoryFileHeader.versionNeededToExtract;
        this.generalPurposeBitFlag = this.linkedDirectoryFileHeader.generalPurposeBitFlag;
        this.compressionMethod = this.linkedDirectoryFileHeader.compressionMethod;
        this.lastModFileTime = this.linkedDirectoryFileHeader.lastModFileTime;
        this.lastModFileDate = this.linkedDirectoryFileHeader.lastModFileDate;
        this.crc32 = this.linkedDirectoryFileHeader.crc32;
        this.fileNameLength = this.linkedDirectoryFileHeader.fileNameLength;
        this.fileName = this.linkedDirectoryFileHeader.fileName;
        if (!this.foundData && (fileDataLength = this.getCompressionMethod() == 0 ? this.getUncompressedSize() & 0xFFFFFFFFL : this.getCompressedSize() & 0xFFFFFFFFL) < this.relativeDataOffsetEnd) {
            this.fileData = (LazyByteData)ByteDataUtil.readLazyLongSlice(this.data, this.offset, new LazyLong(() -> this.relativeDataOffsetStart - this.offset), new LazyLong(() -> fileDataLength)).withId("fileData");
        }
    }
}

