/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.compression.Decompressor;
import software.coley.lljzip.format.model.AbstractZipFileHeader;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.PartType;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.ByteDataUtil;
import software.coley.lljzip.util.lazy.LazyByteData;
import software.coley.lljzip.util.lazy.LazyInt;
import software.coley.lljzip.util.lazy.LazyLong;

public class LocalFileHeader
extends AbstractZipFileHeader {
    protected static final int MIN_FIXED_SIZE = 30;
    protected transient CentralDirectoryFileHeader linkedDirectoryFileHeader;
    protected LazyByteData fileData;
    protected transient LazyLong fileDataLength;

    @Nonnull
    public LocalFileHeader copy() {
        LocalFileHeader copy = new LocalFileHeader();
        copy.data = this.data;
        copy.offset = this.offset;
        copy.linkedDirectoryFileHeader = this.linkedDirectoryFileHeader;
        copy.versionNeededToExtract = this.versionNeededToExtract.copy();
        copy.generalPurposeBitFlag = this.generalPurposeBitFlag.copy();
        copy.compressionMethod = this.compressionMethod.copy();
        copy.lastModFileTime = this.lastModFileTime.copy();
        copy.lastModFileDate = this.lastModFileDate.copy();
        copy.crc32 = this.crc32.copy();
        copy.compressedSize = this.compressedSize.copy();
        copy.uncompressedSize = this.uncompressedSize.copy();
        copy.fileNameLength = this.fileNameLength.copy();
        copy.extraFieldLength = this.extraFieldLength.copy();
        copy.fileName = this.fileName.copy();
        copy.extraField = this.extraField.copy();
        copy.fileDataLength = this.fileDataLength.copy();
        copy.fileData = this.fileData.copy();
        return copy;
    }

    @Override
    public void read(@Nonnull ByteData data, long offset) {
        super.read(data, offset);
        this.versionNeededToExtract = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 4).withId("versionNeededToExtract");
        this.generalPurposeBitFlag = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 6).withId("generalPurposeBitFlag");
        this.compressionMethod = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 8).withId("compressionMethod");
        this.lastModFileTime = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 10).withId("lastModFileTime");
        this.lastModFileDate = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 12).withId("lastModFileDate");
        this.crc32 = (LazyInt)ByteDataUtil.readLazyQuad(data, offset, 14).withId("crc32");
        this.compressedSize = (LazyLong)ByteDataUtil.readLazyMaskedLongQuad(data, offset, 18).withId("compressedSize");
        this.uncompressedSize = (LazyLong)ByteDataUtil.readLazyMaskedLongQuad(data, offset, 22).withId("uncompressedSize");
        this.fileNameLength = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 26).withId("fileNameLength");
        this.extraFieldLength = (LazyInt)ByteDataUtil.readLazyWord(data, offset, 28).withId("extraFieldLength");
        this.fileName = (LazyByteData)ByteDataUtil.readLazySlice(data, offset, new LazyInt(() -> 30), this.fileNameLength).withId("fileName");
        this.extraField = (LazyByteData)ByteDataUtil.readLazySlice(data, offset, this.fileNameLength.add(30), this.extraFieldLength).withId("extraField");
        this.fileDataLength = (LazyLong)new LazyLong(() -> {
            long fileDataLength = this.compressionMethod.get() == 0 ? this.uncompressedSize.get() : this.compressedSize.get();
            return fileDataLength;
        }).withId("fileDataLength");
        this.fileData = (LazyByteData)ByteDataUtil.readLazyLongSlice(data, offset, this.fileNameLength.add(this.extraFieldLength).add(30), this.fileDataLength).withId("fileData");
    }

    public boolean hasDifferentValuesThanCentralDirectoryHeader() {
        if (this.linkedDirectoryFileHeader == null) {
            return false;
        }
        if (this.getVersionNeededToExtract() != this.linkedDirectoryFileHeader.getVersionNeededToExtract()) {
            return true;
        }
        if (this.getGeneralPurposeBitFlag() != this.linkedDirectoryFileHeader.getGeneralPurposeBitFlag()) {
            return true;
        }
        if (this.getCompressionMethod() != this.linkedDirectoryFileHeader.getCompressionMethod()) {
            return true;
        }
        if (this.getLastModFileTime() != this.linkedDirectoryFileHeader.getLastModFileTime()) {
            return true;
        }
        if (this.getLastModFileDate() != this.linkedDirectoryFileHeader.getLastModFileDate()) {
            return true;
        }
        if (this.getCrc32() != this.linkedDirectoryFileHeader.getCrc32()) {
            return true;
        }
        if (this.getCompressedSize() != this.linkedDirectoryFileHeader.getCompressedSize()) {
            return true;
        }
        if (this.getUncompressedSize() != this.linkedDirectoryFileHeader.getUncompressedSize()) {
            return true;
        }
        if (this.getFileNameLength() != this.linkedDirectoryFileHeader.getFileNameLength()) {
            return true;
        }
        return !Objects.equals(this.getFileNameAsString(), this.linkedDirectoryFileHeader.getFileNameAsString());
    }

    public void adoptLinkedCentralDirectoryValues() {
        if (this.linkedDirectoryFileHeader != null) {
            this.versionNeededToExtract = this.linkedDirectoryFileHeader.versionNeededToExtract;
            this.generalPurposeBitFlag = this.linkedDirectoryFileHeader.generalPurposeBitFlag;
            this.compressionMethod = this.linkedDirectoryFileHeader.compressionMethod;
            this.lastModFileTime = this.linkedDirectoryFileHeader.lastModFileTime;
            this.lastModFileDate = this.linkedDirectoryFileHeader.lastModFileDate;
            this.crc32 = this.linkedDirectoryFileHeader.crc32;
            this.compressedSize = this.linkedDirectoryFileHeader.compressedSize;
            this.uncompressedSize = this.linkedDirectoryFileHeader.uncompressedSize;
            this.fileNameLength = this.linkedDirectoryFileHeader.fileNameLength;
            this.fileName = this.linkedDirectoryFileHeader.fileName;
            this.extraField = this.linkedDirectoryFileHeader.extraField;
            this.fileDataLength = (LazyLong)new LazyLong(() -> {
                long fileDataLength = this.compressionMethod.get() == 0 ? this.uncompressedSize.get() : this.compressedSize.get();
                return fileDataLength;
            }).withId("fileDataLength");
            if (this.data != null) {
                this.fileData = (LazyByteData)ByteDataUtil.readLazyLongSlice(this.data, this.offset, this.fileNameLength.add(this.extraFieldLength).add(30), this.fileDataLength).withId("fileData");
            }
        }
    }

    public void setFileDataEndOffset(long endOffset) {
        long fileDataStartOffset = this.offset + (long)this.fileNameLength.add(this.extraFieldLength).add(30).get();
        long length = endOffset - fileDataStartOffset;
        this.setFileDataLength(length);
    }

    public void setFileDataLength(long newLength) {
        this.fileDataLength.set(newLength);
        this.fileData = (LazyByteData)ByteDataUtil.readLazyLongSlice(this.data, this.offset, this.fileNameLength.add(this.extraFieldLength).add(30), newLength).withId("fileData");
    }

    public void setFileDataLength(@Nonnull LazyLong newLength) {
        this.fileDataLength = newLength;
        this.fileData = (LazyByteData)ByteDataUtil.readLazyLongSlice(this.data, this.offset, this.fileNameLength.add(this.extraFieldLength).add(30), newLength).withId("fileData");
    }

    @Override
    public long length() {
        return (long)(30 + this.fileNameLength.get() + this.extraFieldLength.get()) + this.fileDataLength.get();
    }

    @Override
    @Nonnull
    public PartType type() {
        return PartType.LOCAL_FILE_HEADER;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    public ByteData decompress(Decompressor decompressor) throws IOException {
        return decompressor.decompress(this, this.fileData.get());
    }

    public CentralDirectoryFileHeader getLinkedDirectoryFileHeader() {
        return this.linkedDirectoryFileHeader;
    }

    public void link(CentralDirectoryFileHeader directoryFileHeader) {
        this.linkedDirectoryFileHeader = directoryFileHeader;
    }

    public ByteData getFileData() {
        return this.fileData.get();
    }

    public void setFileData(ByteData fileData) {
        this.fileData.set(fileData);
    }

    public String toString() {
        return "LocalFileHeader{fileData=" + this.fileData + ", fileDataLength=" + this.fileDataLength + ", data=" + this.data + ", versionNeededToExtract=" + this.versionNeededToExtract + ", generalPurposeBitFlag=" + this.generalPurposeBitFlag + ", compressionMethod=" + this.compressionMethod + ", lastModFileTime=" + this.lastModFileTime + ", lastModFileDate=" + this.lastModFileDate + ", crc32=" + this.crc32 + ", compressedSize=" + this.compressedSize + ", uncompressedSize=" + this.uncompressedSize + ", fileNameLength=" + this.fileNameLength + ", extraFieldLength=" + this.extraFieldLength + ", fileName='" + this.getFileNameAsString() + '\'' + ", extraField='" + this.getExtraFieldAsString() + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalFileHeader that = (LocalFileHeader)o;
        if (!Objects.equals(this.versionNeededToExtract, that.versionNeededToExtract)) {
            return false;
        }
        if (!Objects.equals(this.generalPurposeBitFlag, that.generalPurposeBitFlag)) {
            return false;
        }
        if (!Objects.equals(this.compressionMethod, that.compressionMethod)) {
            return false;
        }
        if (!Objects.equals(this.lastModFileTime, that.lastModFileTime)) {
            return false;
        }
        if (!Objects.equals(this.lastModFileDate, that.lastModFileDate)) {
            return false;
        }
        if (!Objects.equals(this.crc32, that.crc32)) {
            return false;
        }
        if (!Objects.equals(this.compressedSize, that.compressedSize)) {
            return false;
        }
        if (!Objects.equals(this.uncompressedSize, that.uncompressedSize)) {
            return false;
        }
        if (!Objects.equals(this.fileNameLength, that.fileNameLength)) {
            return false;
        }
        if (!Objects.equals(this.extraFieldLength, that.extraFieldLength)) {
            return false;
        }
        if (!Objects.equals(this.fileName, that.fileName)) {
            return false;
        }
        if (!Objects.equals(this.extraField, that.extraField)) {
            return false;
        }
        if (!Objects.equals(this.fileDataLength, that.fileDataLength)) {
            return false;
        }
        return Objects.equals(this.fileData, that.fileData);
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.versionNeededToExtract != null ? this.versionNeededToExtract.hashCode() : 0);
        result = 31 * result + (this.generalPurposeBitFlag != null ? this.generalPurposeBitFlag.hashCode() : 0);
        result = 31 * result + (this.compressionMethod != null ? this.compressionMethod.hashCode() : 0);
        result = 31 * result + (this.lastModFileTime != null ? this.lastModFileTime.hashCode() : 0);
        result = 31 * result + (this.lastModFileDate != null ? this.lastModFileDate.hashCode() : 0);
        result = 31 * result + (this.crc32 != null ? this.crc32.hashCode() : 0);
        result = 31 * result + (this.compressedSize != null ? this.compressedSize.hashCode() : 0);
        result = 31 * result + (this.uncompressedSize != null ? this.uncompressedSize.hashCode() : 0);
        result = 31 * result + (this.fileNameLength != null ? this.fileNameLength.hashCode() : 0);
        result = 31 * result + (this.extraFieldLength != null ? this.extraFieldLength.hashCode() : 0);
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + (this.extraField != null ? this.extraField.hashCode() : 0);
        result = 31 * result + (this.fileDataLength != null ? this.fileDataLength.hashCode() : 0);
        result = 31 * result + (this.fileData != null ? this.fileData.hashCode() : 0);
        return result;
    }
}

