/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.EndOfCentralDirectory;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.PartType;
import software.coley.lljzip.format.model.ZipPart;
import software.coley.lljzip.format.transform.ZipPartMapper;
import software.coley.lljzip.util.OffsetComparator;

public class ZipArchive
implements AutoCloseable,
Iterable<ZipPart> {
    private final List<ZipPart> parts = new ArrayList<ZipPart>();
    private final Closeable closableBackingResource;

    public ZipArchive() {
        this.closableBackingResource = null;
    }

    public ZipArchive(@Nonnull Closeable closableBackingResource) {
        this.closableBackingResource = closableBackingResource;
    }

    @Nonnull
    public ZipArchive withMapping(@Nonnull ZipPartMapper mapper) {
        ZipArchive copy = new ZipArchive();
        for (ZipPart part : this.parts) {
            ZipPart mappedPart = mapper.map(this, part);
            if (mappedPart == null) continue;
            copy.addPart(mappedPart);
        }
        return copy;
    }

    public void addPart(@Nonnull ZipPart part) {
        this.parts.add(part);
    }

    public void addPart(int index, ZipPart part) {
        this.parts.add(index, part);
    }

    public boolean removePart(ZipPart part) {
        return this.parts.remove(part);
    }

    @Nullable
    public ZipPart removePart(int index) {
        return this.parts.remove(index);
    }

    public void sortParts(Comparator<ZipPart> comparator) {
        this.parts.sort(comparator);
    }

    @Nonnull
    public List<ZipPart> getParts() {
        return Collections.unmodifiableList(this.parts);
    }

    @Nonnull
    public List<CentralDirectoryFileHeader> getNameFilteredCentralDirectories(Predicate<String> nameFilter) {
        return this.getCentralDirectories().stream().filter(c -> nameFilter.test(c.getFileNameAsString())).collect(Collectors.toList());
    }

    @Nonnull
    public List<LocalFileHeader> getNameFilteredLocalFiles(Predicate<String> nameFilter) {
        List<CentralDirectoryFileHeader> centralDirectories = this.getCentralDirectories();
        if (!centralDirectories.isEmpty()) {
            return centralDirectories.stream().filter(c -> nameFilter.test(c.getFileNameAsString())).map(CentralDirectoryFileHeader::getLinkedFileHeader).collect(Collectors.toList());
        }
        return this.getLocalFiles().stream().filter(c -> nameFilter.test(c.getFileNameAsString())).collect(Collectors.toList());
    }

    @Nullable
    public LocalFileHeader getLocalFileByName(String name) {
        List<LocalFileHeader> matches = this.getNameFilteredLocalFiles(name::equals);
        if (matches.isEmpty()) {
            return null;
        }
        return matches.get(0);
    }

    @Nonnull
    public List<LocalFileHeader> getLocalFiles() {
        return this.parts.stream().filter(part -> part.type() == PartType.LOCAL_FILE_HEADER).map(part -> (LocalFileHeader)part).collect(Collectors.toList());
    }

    @Nonnull
    public List<CentralDirectoryFileHeader> getCentralDirectories() {
        return this.parts.stream().filter(part -> part.type() == PartType.CENTRAL_DIRECTORY_FILE_HEADER).map(part -> (CentralDirectoryFileHeader)part).collect(Collectors.toList());
    }

    @Nullable
    public EndOfCentralDirectory getEnd() {
        return this.parts.stream().filter(part -> part.type() == PartType.END_OF_CENTRAL_DIRECTORY).sorted(new OffsetComparator().reversed()).limit(1L).map(part -> (EndOfCentralDirectory)part).findFirst().orElse(null);
    }

    @Nullable
    protected Closeable getClosableBackingResource() {
        return this.closableBackingResource;
    }

    @Override
    public void close() throws IOException {
        if (this.closableBackingResource != null) {
            this.closableBackingResource.close();
        }
    }

    @Override
    public Iterator<ZipPart> iterator() {
        return this.parts.listIterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZipArchive that = (ZipArchive)o;
        return this.parts.equals(that.parts);
    }

    public int hashCode() {
        return this.parts.hashCode();
    }
}

