/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.read;

import java.io.IOException;
import java.util.HashSet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.EndOfCentralDirectory;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.read.AbstractZipReader;
import software.coley.lljzip.format.read.SimpleZipPartAllocator;
import software.coley.lljzip.format.read.ZipPartAllocator;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.ByteDataUtil;
import software.coley.lljzip.util.OffsetComparator;

public class ForwardScanZipReader
extends AbstractZipReader {
    private static final Logger logger = LoggerFactory.getLogger(ForwardScanZipReader.class);

    public ForwardScanZipReader() {
        this(new SimpleZipPartAllocator());
    }

    public ForwardScanZipReader(@Nonnull ZipPartAllocator allocator) {
        super(allocator);
    }

    @Override
    public void read(@Nonnull ZipArchive zip, @Nonnull ByteData data) throws IOException {
        CentralDirectoryFileHeader directory;
        long endOfCentralDirectoryOffset = ByteDataUtil.indexOfQuad(data, 0L, 101010256);
        if (endOfCentralDirectoryOffset < 0L) {
            throw new IOException("No Central-Directory-File-Header found!");
        }
        EndOfCentralDirectory end = this.newEndOfCentralDirectory();
        end.read(data, endOfCentralDirectoryOffset);
        zip.addPart(end);
        long zipStart = ByteDataUtil.indexOfQuad(data, 0L, 67324752);
        long len = data.length();
        for (long centralDirectoryOffset = zipStart + end.getCentralDirectoryOffset(); centralDirectoryOffset < len && data.getInt(centralDirectoryOffset) == 33639248; centralDirectoryOffset += directory.length()) {
            directory = new CentralDirectoryFileHeader();
            directory.read(data, centralDirectoryOffset);
            zip.addPart(directory);
        }
        HashSet<Long> offsets = new HashSet<Long>();
        for (CentralDirectoryFileHeader directory2 : zip.getCentralDirectories()) {
            long offset = zipStart + directory2.getRelativeOffsetOfLocalHeader();
            if (!offsets.contains(offset) && data.getInt(offset) == 67324752) {
                LocalFileHeader file = this.newLocalFileHeader();
                directory2.link(file);
                file.link(directory2);
                file.read(data, offset);
                zip.addPart(file);
                this.postProcessLocalFileHeader(file);
                offsets.add(offset);
                continue;
            }
            logger.warn("Central-Directory-File-Header's offset[{}] to Local-File-Header does not match the Local-File-Header magic!", (Object)offset);
        }
        zip.sortParts(new OffsetComparator());
    }
}

