/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.read;

import java.io.IOException;
import java.util.HashSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coley.lljzip.format.ZipPatterns;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.EndOfCentralDirectory;
import software.coley.lljzip.format.model.JvmLocalFileHeader;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.read.AbstractZipReader;
import software.coley.lljzip.format.read.JvmZipPartAllocator;
import software.coley.lljzip.format.read.ZipPartAllocator;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.ByteDataUtil;
import software.coley.lljzip.util.OffsetComparator;

public class JvmZipReader
extends AbstractZipReader {
    private static final Logger logger = LoggerFactory.getLogger(JvmZipReader.class);
    private final boolean skipRevisitedCenToLocalLinks;

    public JvmZipReader() {
        this(new JvmZipPartAllocator(), true);
    }

    public JvmZipReader(boolean skipRevisitedCenToLocalLinks) {
        this(new JvmZipPartAllocator(), skipRevisitedCenToLocalLinks);
    }

    public JvmZipReader(@Nonnull ZipPartAllocator allocator, boolean skipRevisitedCenToLocalLinks) {
        super(allocator);
        this.skipRevisitedCenToLocalLinks = skipRevisitedCenToLocalLinks;
    }

    @Override
    public void read(@Nonnull ZipArchive zip, @Nonnull ByteData data) throws IOException {
        long endOfCentralDirectoryOffset = ByteDataUtil.lastIndexOfQuad(data, data.length() - 4L, 101010256);
        if (endOfCentralDirectoryOffset < 0L) {
            throw new IOException("No Central-Directory-File-Header found!");
        }
        long precedingEndOfCentralDirectory = ByteDataUtil.lastIndexOfQuad(data, endOfCentralDirectoryOffset - 1L, 101010256);
        EndOfCentralDirectory end = this.newEndOfCentralDirectory();
        end.read(data, endOfCentralDirectoryOffset);
        zip.addPart(end);
        long len = data.length();
        long centralDirectoryOffset = len - (long)ZipPatterns.CENTRAL_DIRECTORY_FILE_HEADER.length;
        long maxRelativeOffset = 0L;
        long centralDirectoryOffsetScanEnd = Math.max(Math.max(precedingEndOfCentralDirectory, 0L), end.getCentralDirectoryOffset());
        while (centralDirectoryOffset > centralDirectoryOffsetScanEnd) {
            if ((centralDirectoryOffset = ByteDataUtil.lastIndexOfQuad(data, centralDirectoryOffset - 1L, 33639248)) < 0L) continue;
            CentralDirectoryFileHeader directory = this.newCentralDirectoryFileHeader();
            directory.read(data, centralDirectoryOffset);
            zip.addPart(directory);
            if (directory.getRelativeOffsetOfLocalHeader() <= maxRelativeOffset) continue;
            maxRelativeOffset = directory.getRelativeOffsetOfLocalHeader();
        }
        long jvmBaseFileOffset = 0L;
        boolean priorZipEndWasBogus = false;
        if (precedingEndOfCentralDirectory != -1L) {
            try {
                EndOfCentralDirectory tempEnd = new EndOfCentralDirectory();
                tempEnd.read(data, precedingEndOfCentralDirectory);
                long hypotheticalJvmBaseOffset = precedingEndOfCentralDirectory + tempEnd.length();
                if (len <= hypotheticalJvmBaseOffset + maxRelativeOffset) {
                    throw new IllegalStateException();
                }
                jvmBaseFileOffset = precedingEndOfCentralDirectory + tempEnd.length();
            }
            catch (Exception ex) {
                priorZipEndWasBogus = true;
            }
        }
        if (priorZipEndWasBogus || precedingEndOfCentralDirectory == -1L) {
            jvmBaseFileOffset = end.offset() - end.getCentralDirectorySize() - end.getCentralDirectoryOffset();
            jvmBaseFileOffset = ByteDataUtil.indexOfWord(data, jvmBaseFileOffset, 19280);
            while (jvmBaseFileOffset >= 0L) {
                try {
                    if (data.getInt(jvmBaseFileOffset) == 67324752) {
                        new LocalFileHeader().read(data, jvmBaseFileOffset);
                        break;
                    }
                    if (data.getInt(jvmBaseFileOffset) == 33639248) {
                        new CentralDirectoryFileHeader().read(data, jvmBaseFileOffset);
                        break;
                    }
                    throw new IllegalStateException("No match for LocalFileHeader/CentralDirectoryFileHeader");
                }
                catch (Exception ex) {
                    jvmBaseFileOffset = ByteDataUtil.indexOfWord(data, jvmBaseFileOffset + 1L, 19280);
                }
            }
        }
        HashSet<Long> offsets = new HashSet<Long>();
        TreeSet<Long> entryOffsets = new TreeSet<Long>();
        long earliestCdfh = Long.MAX_VALUE;
        for (CentralDirectoryFileHeader directory : zip.getCentralDirectories()) {
            long offset;
            if (directory.offset() < earliestCdfh) {
                earliestCdfh = directory.offset();
            }
            if (data.getInt(offset = jvmBaseFileOffset + directory.getRelativeOffsetOfLocalHeader()) != 67324752) continue;
            entryOffsets.add(offset);
        }
        entryOffsets.add(earliestCdfh);
        entryOffsets.add(endOfCentralDirectoryOffset);
        for (CentralDirectoryFileHeader directory : zip.getCentralDirectories()) {
            long relative = directory.getRelativeOffsetOfLocalHeader();
            long offset = jvmBaseFileOffset + relative;
            boolean isNewOffset = offsets.add(offset);
            if (!isNewOffset) {
                logger.warn("Central-Directory-File-Header's offset[{}] was already visited", (Object)offset);
                if (this.skipRevisitedCenToLocalLinks) continue;
            }
            if (data.getInt(offset) != 67324752) {
                logger.warn("Central-Directory-File-Header's offset[{}] to Local-File-Header does not match the Local-File-Header magic!", (Object)offset);
                continue;
            }
            try {
                LocalFileHeader file = this.newLocalFileHeader();
                if (file instanceof JvmLocalFileHeader) {
                    ((JvmLocalFileHeader)file).setOffsets(entryOffsets);
                }
                file.read(data, offset);
                directory.link(file);
                file.link(directory);
                file.adoptLinkedCentralDirectoryValues();
                zip.addPart(file);
                this.postProcessLocalFileHeader(file);
            }
            catch (Exception ex) {
                logger.warn("Failed to read 'local file header' at offset[{}]", (Object)offset, (Object)ex);
            }
        }
        zip.sortParts(new OffsetComparator());
    }
}

