/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.transform;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.EndOfCentralDirectory;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.model.ZipPart;

public interface ZipPartMapper {
    @Nullable
    default public ZipPart map(@Nonnull ZipArchive archive, @Nonnull ZipPart part) {
        if (part instanceof LocalFileHeader) {
            return this.mapLocal(archive, (LocalFileHeader)part);
        }
        if (part instanceof CentralDirectoryFileHeader) {
            return this.mapCentral(archive, (CentralDirectoryFileHeader)part);
        }
        if (part instanceof EndOfCentralDirectory) {
            return this.mapEnd(archive, (EndOfCentralDirectory)part);
        }
        return part;
    }

    @Nullable
    public LocalFileHeader mapLocal(@Nonnull ZipArchive var1, @Nonnull LocalFileHeader var2);

    @Nullable
    public CentralDirectoryFileHeader mapCentral(@Nonnull ZipArchive var1, @Nonnull CentralDirectoryFileHeader var2);

    @Nullable
    public EndOfCentralDirectory mapEnd(@Nonnull ZipArchive var1, @Nonnull EndOfCentralDirectory var2);
}

