/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.write;

import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.EndOfCentralDirectory;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.write.ZipWriter;
import software.coley.lljzip.util.ByteDataUtil;

public class DirectZipWriter
implements ZipWriter {
    @Override
    public void write(@Nonnull ZipArchive archive, @Nonnull OutputStream os) throws IOException {
        for (LocalFileHeader fileHeader : archive.getLocalFiles()) {
            DirectZipWriter.writeIntLE(os, 67324752);
            DirectZipWriter.writeShortLE(os, fileHeader.getVersionNeededToExtract());
            DirectZipWriter.writeShortLE(os, fileHeader.getGeneralPurposeBitFlag());
            DirectZipWriter.writeShortLE(os, fileHeader.getCompressionMethod());
            DirectZipWriter.writeShortLE(os, fileHeader.getLastModFileTime());
            DirectZipWriter.writeShortLE(os, fileHeader.getLastModFileDate());
            DirectZipWriter.writeIntLE(os, fileHeader.getCrc32());
            DirectZipWriter.writeIntLE(os, (int)fileHeader.getCompressedSize());
            DirectZipWriter.writeIntLE(os, (int)fileHeader.getUncompressedSize());
            DirectZipWriter.writeShortLE(os, fileHeader.getFileNameLength());
            DirectZipWriter.writeShortLE(os, fileHeader.getExtraFieldLength());
            os.write(ByteDataUtil.toByteArray(fileHeader.getFileName()));
            os.write(ByteDataUtil.toByteArray(fileHeader.getExtraField()));
            os.write(ByteDataUtil.toByteArray(fileHeader.getFileData()));
        }
        for (CentralDirectoryFileHeader directory : archive.getCentralDirectories()) {
            DirectZipWriter.writeIntLE(os, 33639248);
            DirectZipWriter.writeShortLE(os, directory.getVersionMadeBy());
            DirectZipWriter.writeShortLE(os, directory.getVersionNeededToExtract());
            DirectZipWriter.writeShortLE(os, directory.getGeneralPurposeBitFlag());
            DirectZipWriter.writeShortLE(os, directory.getCompressionMethod());
            DirectZipWriter.writeShortLE(os, directory.getLastModFileTime());
            DirectZipWriter.writeShortLE(os, directory.getLastModFileDate());
            DirectZipWriter.writeIntLE(os, directory.getCrc32());
            DirectZipWriter.writeIntLE(os, (int)directory.getCompressedSize());
            DirectZipWriter.writeIntLE(os, (int)directory.getUncompressedSize());
            DirectZipWriter.writeShortLE(os, directory.getFileNameLength());
            DirectZipWriter.writeShortLE(os, directory.getExtraFieldLength());
            DirectZipWriter.writeShortLE(os, directory.getFileCommentLength());
            DirectZipWriter.writeShortLE(os, directory.getDiskNumberStart());
            DirectZipWriter.writeShortLE(os, directory.getInternalFileAttributes());
            DirectZipWriter.writeIntLE(os, directory.getExternalFileAttributes());
            DirectZipWriter.writeIntLE(os, (int)directory.getRelativeOffsetOfLocalHeader());
            os.write(ByteDataUtil.toByteArray(directory.getFileName()));
            os.write(ByteDataUtil.toByteArray(directory.getExtraField()));
            os.write(ByteDataUtil.toByteArray(directory.getFileComment()));
        }
        EndOfCentralDirectory end = archive.getEnd();
        if (end != null) {
            DirectZipWriter.writeIntLE(os, 101010256);
            DirectZipWriter.writeShortLE(os, end.getDiskNumber());
            DirectZipWriter.writeShortLE(os, end.getCentralDirectoryStartDisk());
            DirectZipWriter.writeShortLE(os, end.getCentralDirectoryStartOffset());
            DirectZipWriter.writeShortLE(os, end.getNumEntries());
            DirectZipWriter.writeIntLE(os, (int)end.getCentralDirectorySize());
            DirectZipWriter.writeIntLE(os, (int)end.getCentralDirectoryOffset());
            DirectZipWriter.writeShortLE(os, end.getZipCommentLength());
            os.write(ByteDataUtil.toByteArray(end.getZipComment()));
        }
    }

    private static void writeShortLE(OutputStream os, int value) throws IOException {
        os.write(value & 0xFF);
        os.write(value >> 8 & 0xFF);
    }

    private static void writeIntLE(OutputStream os, int value) throws IOException {
        os.write(value & 0xFF);
        os.write(value >> 8 & 0xFF);
        os.write(value >> 16 & 0xFF);
        os.write(value >> 24 & 0xFF);
    }
}

