/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.write;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.compression.ZipCompressions;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.write.ZipWriter;
import software.coley.lljzip.util.ByteDataUtil;

public class ZipOutputStreamZipWriter
implements ZipWriter {
    private final boolean createDirectoryEntries;

    public ZipOutputStreamZipWriter() {
        this(false);
    }

    public ZipOutputStreamZipWriter(boolean createDirectoryEntries) {
        this.createDirectoryEntries = createDirectoryEntries;
    }

    @Override
    public void write(@Nonnull ZipArchive archive, @Nonnull OutputStream os) throws IOException {
        try (ZipOutputStream zos = new ZipOutputStream(os);){
            for (LocalFileHeader fileHeader : archive.getLocalFiles()) {
                String name = fileHeader.getFileNameAsString();
                if (fileHeader.getFileData().length() > 0L) {
                    zos.putNextEntry(new ZipEntry(name));
                    zos.write(ByteDataUtil.toByteArray(ZipCompressions.decompress(fileHeader)));
                    zos.closeEntry();
                    continue;
                }
                if (!this.createDirectoryEntries) continue;
                zos.putNextEntry(new ZipEntry(name));
                zos.closeEntry();
            }
        }
    }
}

