/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.write;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.ZipArchive;

public interface ZipWriter {
    public void write(@Nonnull ZipArchive var1, @Nonnull OutputStream var2) throws IOException;

    default public void writeToDisk(@Nonnull ZipArchive archive, @Nonnull Path path) throws IOException {
        try (BufferedOutputStream fos = new BufferedOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
            this.write(archive, fos);
        }
    }

    default public byte[] writeToByteArray(@Nonnull ZipArchive archive) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.write(archive, baos);
        return baos.toByteArray();
    }
}

