/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicBoolean;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.ByteDataUtil;
import software.coley.lljzip.util.CleanerUtil;

public final class BufferData
implements ByteData {
    private final ByteBuffer buffer;
    private final AtomicBoolean cleaned;

    private BufferData(ByteBuffer buffer, AtomicBoolean cleaned) {
        this.buffer = buffer;
        this.cleaned = cleaned;
    }

    @Override
    public int getInt(long position) {
        this.ensureOpen();
        return this.buffer.getInt(BufferData.validate(position));
    }

    @Override
    public long getLong(long position) {
        this.ensureOpen();
        return this.buffer.getLong(BufferData.validate(position));
    }

    @Override
    public short getShort(long position) {
        this.ensureOpen();
        return this.buffer.getShort(BufferData.validate(position));
    }

    @Override
    public byte get(long position) {
        this.ensureOpen();
        return this.buffer.get(BufferData.validate(position));
    }

    @Override
    public void get(long position, byte[] b, int off, int len) {
        this.ensureOpen();
        ByteBuffer buffer = this.buffer.slice();
        buffer.order(buffer.order());
        ((Buffer)buffer).position(BufferData.validate(position));
        buffer.get(b, off, len);
    }

    @Override
    public void transferTo(OutputStream out, byte[] buf) throws IOException {
        int remaining;
        this.ensureOpen();
        ByteBuffer buffer = this.buffer;
        if (buffer.hasArray()) {
            out.write(buffer.array(), buffer.arrayOffset() + buffer.position(), remaining);
        } else {
            int length;
            ((Buffer)buffer).mark();
            int copyThreshold = buf.length;
            for (remaining = buffer.remaining(); remaining != 0; remaining -= length) {
                length = Math.min(copyThreshold, remaining);
                buffer.get(buf, 0, length);
                out.write(buf, 0, length);
            }
            ((Buffer)buffer).reset();
        }
    }

    @Override
    public ByteData slice(long startIndex, long endIndex) {
        this.ensureOpen();
        return new BufferData(ByteDataUtil.sliceExact(this.buffer, BufferData.validate(startIndex), BufferData.validate(endIndex)), this.cleaned);
    }

    @Override
    public long length() {
        this.ensureOpen();
        return ByteDataUtil.length(this.buffer);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BufferData)) {
            return false;
        }
        BufferData that = (BufferData)o;
        return this.buffer.equals(that.buffer);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (!this.cleaned.get()) {
            BufferData bufferData = this;
            synchronized (bufferData) {
                if (this.cleaned.get()) {
                    return;
                }
                this.cleaned.set(true);
                ByteBuffer buffer = this.buffer;
                if (buffer.isDirect()) {
                    CleanerUtil.invokeCleaner(buffer);
                }
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.cleaned.get();
    }

    private void ensureOpen() {
        if (this.cleaned.get()) {
            throw new IllegalStateException("Cannot access data after close");
        }
    }

    private static int validate(long v) {
        if (v < 0L || v > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(Long.toString(v));
        }
        return (int)v;
    }

    public static BufferData wrap(ByteBuffer buffer) {
        return new BufferData(buffer, new AtomicBoolean());
    }

    public static BufferData wrap(byte[] array) {
        return new BufferData(ByteBuffer.wrap(array).order(ByteOrder.LITTLE_ENDIAN), new AtomicBoolean());
    }

    public static BufferData wrap(byte[] array, int offset, int length) {
        return new BufferData(ByteBuffer.wrap(array, offset, length).order(ByteOrder.LITTLE_ENDIAN), new AtomicBoolean());
    }
}

