/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import software.coley.lljzip.util.ByteData;
import software.coley.lljzip.util.lazy.LazyByteData;
import software.coley.lljzip.util.lazy.LazyInt;
import software.coley.lljzip.util.lazy.LazyLong;

public class ByteDataUtil {
    public static final int WILDCARD = Integer.MIN_VALUE;

    public static long indexOfWord(ByteData data, long offset, int pattern) {
        long len = data.length() - 2L;
        for (long i = offset; i < len; ++i) {
            if (pattern != data.getShort(i)) continue;
            return i;
        }
        return -1L;
    }

    public static long indexOfQuad(ByteData data, long offset, int pattern) {
        long len = data.length() - 4L;
        long i = offset;
        while (i < len) {
            int value = data.getInt(i);
            if (pattern == value) {
                return i;
            }
            if ((pattern & 0xFFFFFF) == (value & 0xFFFFFF00) >>> 8) {
                ++i;
                continue;
            }
            if ((pattern & 0xFFFF) == (value & 0xFFFF0000) >>> 16) {
                i += 2L;
                continue;
            }
            if ((pattern & 0xFF) == (value & 0xFF000000) >>> 24) {
                i += 3L;
                continue;
            }
            i += 4L;
        }
        return -1L;
    }

    public static long lastIndexOfWord(ByteData data, long offset, int pattern) {
        long limit;
        if (data == null || (limit = data.length()) < 2L || offset >= limit) {
            return -1L;
        }
        for (long i = offset; i >= 0L; --i) {
            if (pattern != data.getShort(i)) continue;
            return i;
        }
        return -1L;
    }

    public static long lastIndexOfQuad(ByteData data, long offset, int pattern) {
        long limit;
        if (data == null || (limit = data.length()) < 4L || offset >= limit) {
            return -1L;
        }
        long i = offset;
        while (i >= 0L) {
            int value = data.getInt(i);
            if (pattern == value) {
                return i;
            }
            if ((pattern & 0xFFFFFF00) >>> 8 == (value & 0xFFFFFF)) {
                --i;
                continue;
            }
            if ((pattern & 0xFFFF0000) >>> 16 == (value & 0xFFFF)) {
                i -= 2L;
                continue;
            }
            if ((pattern & 0xFFFFFF00) >>> 24 == (value & 0xFF)) {
                i -= 3L;
                continue;
            }
            i -= 4L;
        }
        return -1L;
    }

    public static long indexOf(ByteData data, int[] pattern) {
        return ByteDataUtil.indexOf(data, 0L, pattern);
    }

    public static long indexOf(ByteData data, long offset, int[] pattern) {
        long limit;
        if (data == null || (limit = data.length()) < (long)pattern.length || offset >= limit) {
            return -1L;
        }
        for (long i = offset; i < limit; ++i) {
            if (!ByteDataUtil.startsWith(data, i, pattern)) continue;
            return i;
        }
        return -1L;
    }

    public static long lastIndexOf(ByteData data, int[] pattern) {
        return ByteDataUtil.lastIndexOf(data, data.length() - (long)pattern.length, pattern);
    }

    public static long lastIndexOf(ByteData data, long offset, int[] pattern) {
        if (data == null || data.length() < (long)pattern.length) {
            return -1L;
        }
        for (long i = offset; i >= 0L; --i) {
            if (!ByteDataUtil.startsWith(data, i, pattern)) continue;
            return i;
        }
        return -1L;
    }

    public static boolean startsWith(ByteData data, long offset, int[] pattern) {
        if (data == null || data.length() - offset < (long)pattern.length || offset < 0L || offset >= data.length()) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            int p = pattern[i];
            if (p == Integer.MIN_VALUE || data.get(offset + (long)i) == p) continue;
            return false;
        }
        return true;
    }

    public static int readWord(ByteData data, long i) {
        return data.getShort(i) & 0xFFFF;
    }

    public static int readQuad(ByteData data, long i) {
        return data.getInt(i);
    }

    public static String readString(ByteData data, long start, int len) {
        if (len == 0) {
            return "";
        }
        byte[] bytes = new byte[len];
        data.get(start, bytes, 0, len);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] readArray(ByteData data, int start, int len) {
        byte[] bytes = new byte[len];
        data.get(start, bytes, 0, len);
        return bytes;
    }

    public static ByteBuffer sliceExact(ByteBuffer data, int start, int end) {
        ByteBuffer slice = data.slice();
        slice = ((ByteBuffer)((Buffer)slice).position(start)).slice();
        ((Buffer)slice).limit(end - start);
        return slice.order(data.order());
    }

    public static ByteData slice(ByteData data, long start, long len) {
        return data.slice(start, start + len);
    }

    public static int length(ByteBuffer data) {
        return data.remaining() - data.position();
    }

    public static byte[] toByteArray(ByteData data) {
        long length = data.length();
        if (length > 0x7FFFFFF7L) {
            throw new IllegalStateException("Data too big!");
        }
        byte[] bytes = new byte[(int)length];
        data.get(0L, bytes, 0, bytes.length);
        return bytes;
    }

    public static String toString(ByteData data) {
        return new String(ByteDataUtil.toByteArray(data), StandardCharsets.UTF_8);
    }

    public static boolean equals(ByteData a, ByteData b) {
        return Objects.equals(a, b);
    }

    public static LazyInt readLazyWord(ByteData data, long headerOffset, int localOffset) {
        return new LazyInt(() -> {
            if (data.isClosed()) {
                throw new IllegalStateException("Cannot read from closed data source");
            }
            return ByteDataUtil.readWord(data, headerOffset + (long)localOffset);
        });
    }

    public static LazyInt readLazyQuad(ByteData data, long headerOffset, int localOffset) {
        return new LazyInt(() -> {
            if (data.isClosed()) {
                throw new IllegalStateException("Cannot read from closed data source");
            }
            return ByteDataUtil.readQuad(data, headerOffset + (long)localOffset);
        });
    }

    public static LazyInt readLazyMaskedQuad(ByteData data, long headerOffset, int localOffset) {
        return new LazyInt(() -> {
            if (data.isClosed()) {
                throw new IllegalStateException("Cannot read from closed data source");
            }
            return ByteDataUtil.readQuad(data, headerOffset + (long)localOffset) & 0xFFFF;
        });
    }

    public static LazyLong readLazyLongWord(ByteData data, long headerOffset, int localOffset) {
        return new LazyLong(() -> {
            if (data.isClosed()) {
                throw new IllegalStateException("Cannot read from closed data source");
            }
            return ByteDataUtil.readWord(data, headerOffset + (long)localOffset);
        });
    }

    public static LazyLong readLazyMaskedLongQuad(ByteData data, long headerOffset, int localOffset) {
        return new LazyLong(() -> {
            if (data.isClosed()) {
                throw new IllegalStateException("Cannot read from closed data source");
            }
            return (long)ByteDataUtil.readQuad(data, headerOffset + (long)localOffset) & 0xFFFFFFFFL;
        });
    }

    public static LazyByteData readLazySlice(ByteData data, long headerOffset, LazyInt localOffset, LazyInt length) {
        return new LazyByteData(() -> {
            if (data.isClosed()) {
                throw new IllegalStateException("Cannot read from closed data source");
            }
            return data.sliceOf(headerOffset + (long)localOffset.get(), length.get());
        });
    }

    public static LazyByteData readLazyLongSlice(ByteData data, long headerOffset, LazyInt localOffset, LazyLong length) {
        return new LazyByteData(() -> {
            if (data.isClosed()) {
                throw new IllegalStateException("Cannot read from closed data source");
            }
            return data.sliceOf(headerOffset + (long)localOffset.get(), length.get());
        });
    }

    public static LazyByteData readLazyLongSlice(ByteData data, long headerOffset, LazyLong localOffset, LazyLong length) {
        return new LazyByteData(() -> {
            if (data.isClosed()) {
                throw new IllegalStateException("Cannot read from closed data source");
            }
            return data.sliceOf(headerOffset + localOffset.get(), length.get());
        });
    }

    public static LazyByteData readLazyLongSlice(ByteData data, long headerOffset, LazyInt localOffset, long length) {
        return new LazyByteData(() -> {
            if (data.isClosed()) {
                throw new IllegalStateException("Cannot read from closed data source");
            }
            return data.sliceOf(headerOffset + (long)localOffset.get(), length);
        });
    }
}

