/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import software.coley.lljzip.util.UnsafeUtil;
import sun.misc.Unsafe;

public final class CleanerUtil {
    private static final Method INVOKE_CLEANER;
    private static final Method GET_CLEANER;
    private static final boolean SUPPORTED;

    private CleanerUtil() {
    }

    public static void invokeCleaner(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            throw new IllegalStateException("buffer is not direct");
        }
        if (!SUPPORTED) {
            return;
        }
        Method getCleaner = GET_CLEANER;
        Method invokeCleaner = INVOKE_CLEANER;
        try {
            if (getCleaner != null) {
                Object cleaner = getCleaner.invoke((Object)buffer, new Object[0]);
                if (cleaner == null) {
                    throw new IllegalStateException("slice or duplicate");
                }
                invokeCleaner.invoke(cleaner, new Object[0]);
            } else {
                invokeCleaner.invoke((Object)UnsafeUtil.get(), buffer);
            }
        }
        catch (InvocationTargetException ex) {
            throw new IllegalStateException("Failed to invoke clean method", ex.getTargetException());
        }
        catch (IllegalAccessException ex) {
            throw new IllegalStateException("cleaner became inaccessible", ex);
        }
    }

    static {
        Method invokeCleaner;
        boolean supported = false;
        Method getCleaner = null;
        try {
            invokeCleaner = Unsafe.class.getDeclaredMethod("invokeCleaner", ByteBuffer.class);
            invokeCleaner.setAccessible(true);
            ByteBuffer tmp = ByteBuffer.allocateDirect(1);
            invokeCleaner.invoke((Object)UnsafeUtil.get(), tmp);
            supported = true;
        }
        catch (NoSuchMethodException ignored) {
            supported = true;
            ByteBuffer tmp = ByteBuffer.allocateDirect(1);
            try {
                Class<?> directBuffer = Class.forName("sun.nio.ch.DirectBuffer");
                getCleaner = directBuffer.getDeclaredMethod("cleaner", new Class[0]);
                invokeCleaner = getCleaner.getReturnType().getDeclaredMethod("clean", new Class[0]);
                invokeCleaner.setAccessible(true);
                getCleaner.setAccessible(true);
                invokeCleaner.invoke(getCleaner.invoke((Object)tmp, new Object[0]), new Object[0]);
            }
            catch (Exception ignored1) {
                invokeCleaner = null;
                getCleaner = null;
                supported = false;
            }
        }
        catch (Exception ex) {
            invokeCleaner = null;
        }
        INVOKE_CLEANER = invokeCleaner;
        GET_CLEANER = getCleaner;
        SUPPORTED = supported;
    }
}

