/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util.lazy;

import java.util.function.LongSupplier;
import javax.annotation.Nonnull;
import software.coley.lljzip.util.lazy.Lazy;

public class LazyLong
extends Lazy<LongSupplier> {
    private long value;

    public LazyLong(@Nonnull LongSupplier lookup) {
        super(lookup);
    }

    @Nonnull
    public LazyLong copy() {
        LazyLong copy = new LazyLong((LongSupplier)this.lookup);
        copy.id = this.id;
        if (this.set) {
            copy.set(this.value);
        }
        return copy;
    }

    public void set(long value) {
        this.set = true;
        this.value = value;
    }

    public long get() {
        if (!this.set) {
            this.value = ((LongSupplier)this.lookup).getAsLong();
            this.set = true;
        }
        return this.value;
    }

    public String toString() {
        return this.id + " " + this.get();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LazyLong lazyLong = (LazyLong)o;
        return this.get() == lazyLong.get();
    }

    public int hashCode() {
        long v = this.get();
        return (int)(v ^ v >>> 32);
    }
}

