/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.read;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.foreign.MemorySegment;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.AdaptingLocalFileHeader;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.read.ZipReader;

public class AdaptingZipReader
implements ZipReader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read(@Nonnull ZipArchive zip, @Nonnull MemorySegment data) throws IOException {
        File temp = File.createTempFile("lljzip", ".tempzip");
        try {
            try (OutputStream os = Files.newOutputStream(temp.toPath(), new OpenOption[0]);){
                int BUFFER_SIZE = 16384;
                byte[] buf = new byte[16384];
                MemorySegment wrapper = MemorySegment.ofArray(buf);
                long length = data.byteSize();
                for (long offset = 0L; offset < length; offset += length) {
                    int copyable = (int)Math.min(16384L, length - offset);
                    MemorySegment.copy(data, offset, wrapper, 0L, copyable);
                    os.write(buf, 0, copyable);
                }
            }
            AdaptingZipReader.fill(zip, temp);
        }
        finally {
            temp.delete();
        }
    }

    public static void fill(@Nonnull ZipArchive to, @Nonnull File from) throws IOException {
        try (ZipFile zipFile = new ZipFile(from);){
            AdaptingZipReader.fill(to, zipFile);
        }
    }

    public static void fill(@Nonnull ZipArchive to, @Nonnull ZipFile from) throws IOException {
        Enumeration<? extends ZipEntry> zipEntries = from.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry entry = zipEntries.nextElement();
            to.addPart(new AdaptingLocalFileHeader(from, entry));
        }
    }
}

