/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.read;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.EndOfCentralDirectory;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.model.ZipParseException;
import software.coley.lljzip.format.read.AbstractZipReader;
import software.coley.lljzip.format.read.SimpleZipPartAllocator;
import software.coley.lljzip.format.read.ZipPartAllocator;
import software.coley.lljzip.util.MemorySegmentUtil;
import software.coley.lljzip.util.OffsetComparator;

public class ForwardScanZipReader
extends AbstractZipReader {
    private static final Logger logger = LoggerFactory.getLogger(ForwardScanZipReader.class);

    public ForwardScanZipReader() {
        this(new SimpleZipPartAllocator());
    }

    public ForwardScanZipReader(@Nonnull ZipPartAllocator allocator) {
        super(allocator);
    }

    @Override
    public void read(@Nonnull ZipArchive zip, @Nonnull MemorySegment data) throws IOException {
        CentralDirectoryFileHeader directory;
        long endOfCentralDirectoryOffset = MemorySegmentUtil.indexOfQuad(data, 0L, 101010256);
        if (endOfCentralDirectoryOffset < 0L) {
            throw new IOException("No Central-Directory-File-Header found!");
        }
        EndOfCentralDirectory end = this.newEndOfCentralDirectory();
        end.read(data, endOfCentralDirectoryOffset);
        zip.addPart(end);
        long zipStart = MemorySegmentUtil.indexOfQuad(data, 0L, 67324752);
        long len = data.byteSize();
        for (long centralDirectoryOffset = zipStart + end.getCentralDirectoryOffset(); centralDirectoryOffset < len && MemorySegmentUtil.readQuad(data, centralDirectoryOffset) == 33639248; centralDirectoryOffset += directory.length()) {
            directory = new CentralDirectoryFileHeader();
            try {
                directory.read(data, centralDirectoryOffset);
            }
            catch (ZipParseException ex) {
                throw new IOException(ex);
            }
            zip.addPart(directory);
        }
        TreeSet<Long> offsets = new TreeSet<Long>();
        for (CentralDirectoryFileHeader directory2 : zip.getCentralDirectories()) {
            long offset = zipStart + directory2.getRelativeOffsetOfLocalHeader();
            if (!offsets.contains(offset) && MemorySegmentUtil.readQuad(data, offset) == 67324752) {
                LocalFileHeader file = this.newLocalFileHeader();
                directory2.link(file);
                file.link(directory2);
                try {
                    file.read(data, offset);
                }
                catch (ZipParseException ex) {
                    throw new IOException(ex);
                }
                zip.addPart(file);
                this.postProcessLocalFileHeader(file);
                offsets.add(offset);
                continue;
            }
            logger.warn("Central-Directory-File-Header's offset[{}] to Local-File-Header does not match the Local-File-Header magic!", (Object)offset);
        }
        if (!offsets.isEmpty()) {
            long firstOffset = (Long)offsets.first();
            zip.setPrefixData(data.asSlice(0L, firstOffset));
        }
        zip.sortParts(new OffsetComparator());
    }
}

