/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.transform;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.EndOfCentralDirectory;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.model.ZipPart;

public interface ZipPartMapper {
    @Nullable
    default public ZipPart map(@Nonnull ZipArchive archive, @Nonnull ZipPart part) {
        ZipPart zipPart = part;
        Objects.requireNonNull(zipPart);
        ZipPart zipPart2 = zipPart;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{LocalFileHeader.class, CentralDirectoryFileHeader.class, EndOfCentralDirectory.class}, (Object)zipPart2, n)) {
            case 0 -> {
                LocalFileHeader localFileHeader = (LocalFileHeader)zipPart2;
                yield this.mapLocal(archive, localFileHeader);
            }
            case 1 -> {
                CentralDirectoryFileHeader centralDirectoryFileHeader = (CentralDirectoryFileHeader)zipPart2;
                yield this.mapCentral(archive, centralDirectoryFileHeader);
            }
            case 2 -> {
                EndOfCentralDirectory endOfCentralDirectory = (EndOfCentralDirectory)zipPart2;
                yield this.mapEnd(archive, endOfCentralDirectory);
            }
            default -> part;
        };
    }

    @Nullable
    public LocalFileHeader mapLocal(@Nonnull ZipArchive var1, @Nonnull LocalFileHeader var2);

    @Nullable
    public CentralDirectoryFileHeader mapCentral(@Nonnull ZipArchive var1, @Nonnull CentralDirectoryFileHeader var2);

    @Nullable
    public EndOfCentralDirectory mapEnd(@Nonnull ZipArchive var1, @Nonnull EndOfCentralDirectory var2);
}

