/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.file.attribute.FileTime;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.util.MemorySegmentUtil;

public class ExtraFieldTime {
    @Nullable
    public static TimeWrapper read(@Nonnull CentralDirectoryFileHeader header) {
        int extraLen = header.getExtraFieldLength();
        if (extraLen > 0 && extraLen < 65535) {
            MemorySegment extra = header.getExtraField().get();
            return ExtraFieldTime.read(extra);
        }
        return null;
    }

    @Nullable
    public static TimeWrapper read(@Nonnull LocalFileHeader header) {
        int extraLen = header.getExtraFieldLength();
        if (extraLen > 0 && extraLen < 65535) {
            MemorySegment extra = header.getExtraField().get();
            return ExtraFieldTime.read(extra);
        }
        return null;
    }

    @Nonnull
    private static TimeWrapper read(@Nonnull MemorySegment extra) {
        TimeWrapper wrapper = new TimeWrapper();
        int off = 0;
        int len = (int)extra.byteSize();
        while (off + 4 < len) {
            int size;
            int tag = MemorySegmentUtil.readWord(extra, off);
            if ((off += 4) + (size = MemorySegmentUtil.readWord(extra, off + 2)) > len) break;
            if (tag == 10) {
                int pos;
                if (size < 32 || MemorySegmentUtil.readWord(extra, pos = off + 4) != 1 || MemorySegmentUtil.readWord(extra, pos + 2) != 24) break;
                long wtime = (long)MemorySegmentUtil.readQuad(extra, pos + 4) | (long)MemorySegmentUtil.readQuad(extra, pos + 8) << 32;
                if (wtime != Long.MIN_VALUE) {
                    wrapper.modify = ExtraFieldTime.winTimeToFileTime(wtime).toMillis();
                }
                if ((wtime = (long)MemorySegmentUtil.readQuad(extra, pos + 12) | (long)MemorySegmentUtil.readQuad(extra, pos + 16) << 32) != Long.MIN_VALUE) {
                    wrapper.access = ExtraFieldTime.winTimeToFileTime(wtime).toMillis();
                }
                if ((wtime = (long)MemorySegmentUtil.readQuad(extra, pos + 20) | (long)MemorySegmentUtil.readQuad(extra, pos + 8) << 24) != Long.MIN_VALUE) {
                    wrapper.creation = ExtraFieldTime.winTimeToFileTime(wtime).toMillis();
                }
            } else if (tag == 21589) {
                int flag = extra.get(ValueLayout.JAVA_BYTE, (long)off) & 0xFF;
                int localOff = 1;
                if ((flag & 1) != 0 && localOff + 4 <= size) {
                    wrapper.modify = ExtraFieldTime.unixTimeToFileTime(MemorySegmentUtil.readQuad(extra, off + localOff)).toMillis();
                    localOff += 4;
                }
                if ((flag & 2) != 0 && localOff + 4 <= size) {
                    wrapper.access = ExtraFieldTime.unixTimeToFileTime(MemorySegmentUtil.readQuad(extra, off + localOff)).toMillis();
                    localOff += 4;
                }
                if ((flag & 4) != 0 && localOff + 4 <= size) {
                    wrapper.creation = ExtraFieldTime.unixTimeToFileTime(MemorySegmentUtil.readQuad(extra, off + localOff)).toMillis();
                    localOff += 4;
                }
            }
            off += size;
        }
        return wrapper;
    }

    @Nonnull
    public static FileTime winTimeToFileTime(long time) {
        return FileTime.from(time / 10L - 11644473600000000L, TimeUnit.MICROSECONDS);
    }

    @Nonnull
    public static FileTime unixTimeToFileTime(long utime) {
        return FileTime.from(utime, TimeUnit.SECONDS);
    }

    public static class TimeWrapper {
        private long creation;
        private long access;
        private long modify;

        public long getCreationMs() {
            return this.creation;
        }

        public long getAccessMs() {
            return this.access;
        }

        public long getModifyMs() {
            return this.modify;
        }
    }
}

