/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.compression;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import java.util.zip.ZipException;
import software.coley.lljzip.format.compression.Decompressor;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.util.FastWrapOutputStream;

public class DeflateDecompressor
implements Decompressor {
    public static final DeflateDecompressor INSTANCE = new DeflateDecompressor();

    private DeflateDecompressor() {
    }

    @Override
    public MemorySegment decompress(LocalFileHeader header, MemorySegment data) throws IOException {
        if (header.getCompressionMethod() != 8) {
            throw new IOException("LocalFileHeader contents not using 'Deflated'!");
        }
        Inflater inflater = new Inflater(true);
        FastWrapOutputStream out = new FastWrapOutputStream();
        try {
            byte[] output = new byte[1024];
            byte[] buffer = new byte[1024];
            MemorySegment bufferSegment = MemorySegment.ofArray(buffer);
            long position = 0L;
            long length = data.byteSize();
            do {
                int count;
                if (inflater.needsInput()) {
                    int remaining = (int)Math.min((long)buffer.length, length);
                    if (remaining == 0) {
                        break;
                    }
                    MemorySegment.copy(data, position, bufferSegment, 0L, remaining);
                    length -= (long)remaining;
                    position += (long)remaining;
                    inflater.setInput(buffer, 0, remaining);
                }
                if ((count = inflater.inflate(output)) == 0) continue;
                out.write(output, 0, count);
            } while (!inflater.finished());
        }
        catch (DataFormatException e) {
            String s = e.getMessage();
            throw (ZipException)new ZipException(s != null ? s : "Invalid ZLIB data format").initCause(e);
        }
        finally {
            inflater.end();
        }
        return out.wrap();
    }
}

