/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.compression;

import java.io.IOException;
import java.io.InputStream;
import java.lang.foreign.MemorySegment;
import java.util.zip.DeflaterInputStream;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.compression.UnsafeDeflateDecompressor;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.util.MemorySegmentInputStream;

public interface ZipCompressions {
    public static final int STORED = 0;
    public static final int SHRUNK = 1;
    public static final int REDUCED_F1 = 2;
    public static final int REDUCED_F2 = 3;
    public static final int REDUCED_F3 = 4;
    public static final int REDUCED_F4 = 5;
    public static final int IMPLODED = 6;
    public static final int RESERVED_TOKENIZING = 7;
    public static final int DEFLATED = 8;
    public static final int DEFLATED_64 = 9;
    public static final int PKWARE_IMPLODING = 10;
    public static final int PKWARE_RESERVED_11 = 11;
    public static final int BZIP2 = 12;
    public static final int PKWARE_RESERVED_13 = 13;
    public static final int LZMA = 14;
    public static final int PKWARE_RESERVED_15 = 15;
    public static final int CMPSC = 16;
    public static final int PKWARE_RESERVED_17 = 17;
    public static final int IBM_TERSE = 18;
    public static final int IBM_LZ77 = 19;
    public static final int DEPRECATED_ZSTD = 20;
    public static final int ZSTANDARD = 93;
    public static final int MP3 = 94;
    public static final int XZ = 95;
    public static final int JPEG = 96;
    public static final int WAVPACK = 97;
    public static final int PPMD = 98;
    public static final int AE_x = 99;

    public static String getName(int method) {
        return switch (method) {
            case 0 -> "STORED";
            case 1 -> "SHRUNK";
            case 2 -> "REDUCED_F1";
            case 3 -> "REDUCED_F2";
            case 4 -> "REDUCED_F3";
            case 5 -> "REDUCED_F4";
            case 6 -> "IMPLODED";
            case 7 -> "RESERVED_TOKENIZING";
            case 8 -> "DEFLATED";
            case 9 -> "DEFLATED_64";
            case 10 -> "PKWARE_IMPLODING";
            case 11 -> "PKWARE_RESERVED_11";
            case 12 -> "BZIP2";
            case 13 -> "PKWARE_RESERVED_13";
            case 14 -> "LZMA";
            case 15 -> "PKWARE_RESERVED_15";
            case 16 -> "CMPSC";
            case 17 -> "PKWARE_RESERVED_17";
            case 18 -> "IBM_TERSE";
            case 19 -> "IBM_LZ77";
            case 20 -> "DEPRECATED_ZSTD";
            case 93 -> "ZSTANDARD";
            case 94 -> "MP3";
            case 95 -> "XZ";
            case 96 -> "JPEG";
            case 97 -> "WAVPACK";
            case 98 -> "PPMD";
            case 99 -> "AE_x";
            default -> "Unknown[" + method + "]";
        };
    }

    @Nonnull
    public static MemorySegment decompress(@Nonnull LocalFileHeader header) throws IOException {
        int method = header.getCompressionMethod();
        return switch (method) {
            case 0 -> header.getFileData();
            case 8 -> header.decompress(UnsafeDeflateDecompressor.INSTANCE);
            default -> {
                String methodName = ZipCompressions.getName(method);
                throw new IOException("Unsupported compression method: " + methodName);
            }
        };
    }

    @Nonnull
    public static InputStream decompressStream(@Nonnull LocalFileHeader header) throws IOException {
        int method = header.getCompressionMethod();
        MemorySegmentInputStream in = new MemorySegmentInputStream(header.getFileData());
        return switch (method) {
            case 0 -> in;
            case 8 -> new DeflaterInputStream(in);
            default -> {
                String methodName = ZipCompressions.getName(method);
                throw new IOException("Unsupported compression method: " + methodName);
            }
        };
    }
}

