/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import java.lang.foreign.MemorySegment;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import software.coley.lljzip.format.model.ZipParseException;
import software.coley.lljzip.format.model.ZipPart;
import software.coley.lljzip.format.model.ZipRead;
import software.coley.lljzip.util.MemorySegmentUtil;
import software.coley.lljzip.util.data.MemorySegmentData;
import software.coley.lljzip.util.data.StringData;

public abstract class AbstractZipFileHeader
implements ZipPart,
ZipRead {
    protected int versionNeededToExtract;
    protected int generalPurposeBitFlag;
    protected int compressionMethod;
    protected int lastModFileTime;
    protected int lastModFileDate;
    protected int crc32;
    protected long compressedSize;
    protected long uncompressedSize;
    protected int fileNameLength;
    protected int extraFieldLength;
    protected StringData fileName;
    protected MemorySegmentData extraField;
    protected transient long offset = -1L;
    protected transient MemorySegment data;

    @Nullable
    public MemorySegment getBackingData() {
        return this.data;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public void read(@Nonnull MemorySegment data, long offset) throws ZipParseException {
        this.data = data;
        this.offset = offset;
    }

    public int getVersionNeededToExtract() {
        return this.versionNeededToExtract;
    }

    public void setVersionNeededToExtract(int versionNeededToExtract) {
        this.versionNeededToExtract = versionNeededToExtract;
    }

    public int getGeneralPurposeBitFlag() {
        return this.generalPurposeBitFlag;
    }

    public void setGeneralPurposeBitFlag(int generalPurposeBitFlag) {
        this.generalPurposeBitFlag = generalPurposeBitFlag;
    }

    public int getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(int compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public int getLastModFileTime() {
        return this.lastModFileTime;
    }

    public void setLastModFileTime(int lastModFileTime) {
        this.lastModFileTime = lastModFileTime;
    }

    public int getLastModFileDate() {
        return this.lastModFileDate;
    }

    public void setLastModFileDate(int lastModFileDate) {
        this.lastModFileDate = lastModFileDate;
    }

    public int getCrc32() {
        return this.crc32;
    }

    public void setCrc32(int crc32) {
        this.crc32 = crc32;
    }

    public long getCompressedSize() {
        return this.compressedSize;
    }

    public void setCompressedSize(long compressedSize) {
        this.compressedSize = compressedSize & 0xFFFFFFFFL;
    }

    public long getUncompressedSize() {
        return this.uncompressedSize;
    }

    public void setUncompressedSize(long uncompressedSize) {
        this.uncompressedSize = uncompressedSize & 0xFFFFFFFFL;
    }

    public int getFileNameLength() {
        return this.fileNameLength;
    }

    public void setFileNameLength(int fileNameLength) {
        this.fileNameLength = fileNameLength & 0xFFFF;
    }

    public int getExtraFieldLength() {
        return this.extraFieldLength;
    }

    public void setExtraFieldLength(int extraFieldLength) {
        this.extraFieldLength = extraFieldLength & 0xFFFF;
    }

    public StringData getFileName() {
        return this.fileName;
    }

    public void setFileName(StringData fileName) {
        this.fileName = fileName;
    }

    public String getFileNameAsString() {
        return this.fileName.get();
    }

    public MemorySegmentData getExtraField() {
        return this.extraField;
    }

    public void setExtraField(MemorySegmentData extraField) {
        this.extraField = extraField;
    }

    public String getExtraFieldAsString() {
        return MemorySegmentUtil.toString(this.extraField.get());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractZipFileHeader)) {
            return false;
        }
        AbstractZipFileHeader that = (AbstractZipFileHeader)o;
        if (this.versionNeededToExtract != that.versionNeededToExtract) {
            return false;
        }
        if (this.generalPurposeBitFlag != that.generalPurposeBitFlag) {
            return false;
        }
        if (this.compressionMethod != that.compressionMethod) {
            return false;
        }
        if (this.lastModFileTime != that.lastModFileTime) {
            return false;
        }
        if (this.lastModFileDate != that.lastModFileDate) {
            return false;
        }
        if (this.crc32 != that.crc32) {
            return false;
        }
        if (this.compressedSize != that.compressedSize) {
            return false;
        }
        if (this.uncompressedSize != that.uncompressedSize) {
            return false;
        }
        if (this.fileNameLength != that.fileNameLength) {
            return false;
        }
        if (this.extraFieldLength != that.extraFieldLength) {
            return false;
        }
        if (this.offset != that.offset) {
            return false;
        }
        if (!Objects.equals(this.fileName, that.fileName)) {
            return false;
        }
        if (!Objects.equals(this.extraField, that.extraField)) {
            return false;
        }
        return Objects.equals(this.data, that.data);
    }

    public int hashCode() {
        int result = this.versionNeededToExtract;
        result = 31 * result + this.generalPurposeBitFlag;
        result = 31 * result + this.compressionMethod;
        result = 31 * result + this.lastModFileTime;
        result = 31 * result + this.lastModFileDate;
        result = 31 * result + this.crc32;
        result = 31 * result + (int)(this.compressedSize ^ this.compressedSize >>> 32);
        result = 31 * result + (int)(this.uncompressedSize ^ this.uncompressedSize >>> 32);
        result = 31 * result + this.fileNameLength;
        result = 31 * result + this.extraFieldLength;
        result = 31 * result + (this.fileName != null ? this.fileName.hashCode() : 0);
        result = 31 * result + (this.extraField != null ? this.extraField.hashCode() : 0);
        result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
        return result;
    }
}

