/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import java.lang.foreign.MemorySegment;
import java.util.Objects;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.PartType;
import software.coley.lljzip.format.model.ZipPart;
import software.coley.lljzip.format.model.ZipRead;
import software.coley.lljzip.util.MemorySegmentUtil;
import software.coley.lljzip.util.data.StringData;

public class EndOfCentralDirectory
implements ZipPart,
ZipRead {
    private transient long offset = -1L;
    private int diskNumber;
    private int centralDirectoryStartDisk;
    private int centralDirectoryStartOffset;
    private int numEntries;
    private long centralDirectorySize;
    private long centralDirectoryOffset;
    private int zipCommentLength;
    private StringData zipComment;

    @Nonnull
    public EndOfCentralDirectory copy() {
        EndOfCentralDirectory copy = new EndOfCentralDirectory();
        copy.offset = this.offset;
        copy.diskNumber = this.diskNumber;
        copy.centralDirectoryStartDisk = this.centralDirectoryStartDisk;
        copy.centralDirectoryStartOffset = this.centralDirectoryStartOffset;
        copy.numEntries = this.numEntries;
        copy.centralDirectorySize = this.centralDirectorySize;
        copy.centralDirectoryOffset = this.centralDirectoryOffset;
        copy.zipCommentLength = this.zipCommentLength;
        copy.zipComment = this.zipComment;
        return copy;
    }

    @Override
    public void read(@Nonnull MemorySegment data, long offset) {
        this.offset = offset;
        this.diskNumber = MemorySegmentUtil.readWord(data, offset + 4L);
        this.centralDirectoryStartDisk = MemorySegmentUtil.readWord(data, offset + 6L);
        this.centralDirectoryStartOffset = MemorySegmentUtil.readWord(data, offset + 8L);
        this.numEntries = MemorySegmentUtil.readWord(data, offset + 10L);
        this.setCentralDirectorySize(MemorySegmentUtil.readQuad(data, offset + 12L));
        this.setCentralDirectoryOffset(MemorySegmentUtil.readQuad(data, offset + 16L));
        this.setZipCommentLength(MemorySegmentUtil.readWord(data, offset + 20L));
        this.zipComment = StringData.of(data, offset + 22L, this.zipCommentLength);
    }

    @Override
    public long length() {
        return 22L + (long)this.zipComment.get().length();
    }

    @Override
    @Nonnull
    public PartType type() {
        return PartType.END_OF_CENTRAL_DIRECTORY;
    }

    @Override
    public long offset() {
        return this.offset;
    }

    public int getDiskNumber() {
        return this.diskNumber;
    }

    public void setDiskNumber(int diskNumber) {
        this.diskNumber = diskNumber;
    }

    public int getCentralDirectoryStartDisk() {
        return this.centralDirectoryStartDisk;
    }

    public void setCentralDirectoryStartDisk(int centralDirectoryStartDisk) {
        this.centralDirectoryStartDisk = centralDirectoryStartDisk;
    }

    public int getCentralDirectoryStartOffset() {
        return this.centralDirectoryStartOffset;
    }

    public void setCentralDirectoryStartOffset(int centralDirectoryStartOffset) {
        this.centralDirectoryStartOffset = centralDirectoryStartOffset;
    }

    public int getNumEntries() {
        return this.numEntries;
    }

    public void setNumEntries(int numEntries) {
        this.numEntries = numEntries;
    }

    public long getCentralDirectorySize() {
        return this.centralDirectorySize;
    }

    public void setCentralDirectorySize(long centralDirectorySize) {
        this.centralDirectorySize = centralDirectorySize & 0xFFFFFFFFL;
    }

    public long getCentralDirectoryOffset() {
        return this.centralDirectoryOffset;
    }

    public void setCentralDirectoryOffset(long centralDirectoryOffset) {
        this.centralDirectoryOffset = centralDirectoryOffset & 0xFFFFFFFFL;
    }

    public int getZipCommentLength() {
        return this.zipCommentLength;
    }

    public void setZipCommentLength(int zipCommentLength) {
        this.zipCommentLength = zipCommentLength & 0xFFFF;
    }

    public StringData getZipComment() {
        return this.zipComment;
    }

    public void setZipComment(StringData zipComment) {
        this.zipComment = zipComment;
    }

    public String getZipCommentAsString() {
        return this.zipComment.get();
    }

    public String toString() {
        return "EndOfCentralDirectory{offset=" + this.offset + ", diskNumber=" + this.diskNumber + ", centralDirectoryStartDisk=" + this.centralDirectoryStartDisk + ", centralDirectoryStartOffset=" + this.centralDirectoryStartOffset + ", numEntries=" + this.numEntries + ", centralDirectorySize=" + this.centralDirectorySize + ", centralDirectoryOffset=" + this.centralDirectoryOffset + ", zipCommentLength=" + this.zipCommentLength + ", zipComment='" + this.getZipCommentAsString() + "'}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EndOfCentralDirectory)) {
            return false;
        }
        EndOfCentralDirectory that = (EndOfCentralDirectory)o;
        if (this.offset != that.offset) {
            return false;
        }
        if (this.diskNumber != that.diskNumber) {
            return false;
        }
        if (this.centralDirectoryStartDisk != that.centralDirectoryStartDisk) {
            return false;
        }
        if (this.centralDirectoryStartOffset != that.centralDirectoryStartOffset) {
            return false;
        }
        if (this.numEntries != that.numEntries) {
            return false;
        }
        if (this.centralDirectorySize != that.centralDirectorySize) {
            return false;
        }
        if (this.centralDirectoryOffset != that.centralDirectoryOffset) {
            return false;
        }
        if (this.zipCommentLength != that.zipCommentLength) {
            return false;
        }
        return Objects.equals(this.zipComment, that.zipComment);
    }

    public int hashCode() {
        int result = (int)(this.offset ^ this.offset >>> 32);
        result = 31 * result + this.diskNumber;
        result = 31 * result + this.centralDirectoryStartDisk;
        result = 31 * result + this.centralDirectoryStartOffset;
        result = 31 * result + this.numEntries;
        result = 31 * result + (int)(this.centralDirectorySize ^ this.centralDirectorySize >>> 32);
        result = 31 * result + (int)(this.centralDirectoryOffset ^ this.centralDirectoryOffset >>> 32);
        result = 31 * result + this.zipCommentLength;
        result = 31 * result + (this.zipComment != null ? this.zipComment.hashCode() : 0);
        return result;
    }
}

