/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import java.lang.foreign.MemorySegment;
import java.util.NavigableSet;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipParseException;
import software.coley.lljzip.util.MemorySegmentUtil;
import software.coley.lljzip.util.data.MemorySegmentData;

public class JvmLocalFileHeader
extends LocalFileHeader {
    private NavigableSet<Long> offsets;
    private long relativeDataOffsetStart;
    private long relativeDataOffsetEnd;
    private boolean foundData;

    public void setOffsets(@Nonnull NavigableSet<Long> offsets) {
        this.offsets = offsets;
    }

    @Override
    public void read(@Nonnull MemorySegment data, long offset) throws ZipParseException {
        block8: {
            try {
                super.read(data, offset);
            }
            catch (ZipParseException ex) {
                if (ex.getType() == ZipParseException.Type.IOOBE_FILE_DATA) break block8;
                throw ex;
            }
        }
        long relativeDataOffsetStart = 30 + this.getFileNameLength() + this.getExtraFieldLength();
        Long absoluteDataOffsetEnd = this.offsets.ceiling(offset + relativeDataOffsetStart);
        if (absoluteDataOffsetEnd != null && (this.getGeneralPurposeBitFlag() & 8) == 8 && (MemorySegmentUtil.readWord(data, absoluteDataOffsetEnd) & 0x4B50) != 19280 && MemorySegmentUtil.readQuad(data, absoluteDataOffsetEnd = Long.valueOf(absoluteDataOffsetEnd - 12L)) == 134695760) {
            absoluteDataOffsetEnd = absoluteDataOffsetEnd - 4L;
        }
        long relativeDataOffsetEnd = absoluteDataOffsetEnd == null ? relativeDataOffsetStart : absoluteDataOffsetEnd - offset;
        this.relativeDataOffsetStart = relativeDataOffsetStart;
        this.relativeDataOffsetEnd = relativeDataOffsetEnd;
        long fileDataLength = relativeDataOffsetEnd - relativeDataOffsetStart;
        try {
            this.fileData = MemorySegmentData.of(MemorySegmentUtil.readLongSlice(data, offset, relativeDataOffsetStart, fileDataLength));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ZipParseException(ex, ZipParseException.Type.IOOBE_FILE_DATA);
        }
        catch (Throwable t) {
            throw new ZipParseException(t, ZipParseException.Type.OTHER);
        }
        if (this.getCompressionMethod() == 0) {
            this.setUncompressedSize(fileDataLength);
            this.setCompressedSize(fileDataLength);
        } else {
            this.setCompressedSize(fileDataLength);
        }
        this.foundData = fileDataLength != 0L;
    }

    @Override
    public void adoptLinkedCentralDirectoryValues() {
        long fileDataLength;
        CentralDirectoryFileHeader directoryFileHeader = this.linkedDirectoryFileHeader;
        if (directoryFileHeader == null) {
            return;
        }
        this.versionNeededToExtract = this.linkedDirectoryFileHeader.versionNeededToExtract;
        this.generalPurposeBitFlag = this.linkedDirectoryFileHeader.generalPurposeBitFlag;
        this.compressionMethod = this.linkedDirectoryFileHeader.compressionMethod;
        this.lastModFileTime = this.linkedDirectoryFileHeader.lastModFileTime;
        this.lastModFileDate = this.linkedDirectoryFileHeader.lastModFileDate;
        this.crc32 = this.linkedDirectoryFileHeader.crc32;
        this.fileNameLength = this.linkedDirectoryFileHeader.fileNameLength;
        this.fileName = this.linkedDirectoryFileHeader.fileName;
        if (!this.foundData && (fileDataLength = this.getCompressionMethod() == 0 ? this.getUncompressedSize() & 0xFFFFFFFFL : this.getCompressedSize() & 0xFFFFFFFFL) < this.relativeDataOffsetEnd) {
            this.fileData = MemorySegmentData.of(MemorySegmentUtil.readLongSlice(this.data, this.offset, this.relativeDataOffsetStart - this.offset, fileDataLength));
        }
    }
}

