/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.util.Objects;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.compression.Decompressor;
import software.coley.lljzip.format.model.AbstractZipFileHeader;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.PartType;
import software.coley.lljzip.format.model.ZipParseException;
import software.coley.lljzip.util.MemorySegmentUtil;
import software.coley.lljzip.util.data.MemorySegmentData;
import software.coley.lljzip.util.data.StringData;

public class LocalFileHeader
extends AbstractZipFileHeader {
    public static final int MIN_FIXED_SIZE = 30;
    protected transient CentralDirectoryFileHeader linkedDirectoryFileHeader;
    protected MemorySegmentData fileData;

    @Nonnull
    public LocalFileHeader copy() {
        LocalFileHeader copy = new LocalFileHeader();
        copy.data = this.data;
        copy.offset = this.offset;
        copy.linkedDirectoryFileHeader = this.linkedDirectoryFileHeader;
        copy.versionNeededToExtract = this.versionNeededToExtract;
        copy.generalPurposeBitFlag = this.generalPurposeBitFlag;
        copy.compressionMethod = this.compressionMethod;
        copy.lastModFileTime = this.lastModFileTime;
        copy.lastModFileDate = this.lastModFileDate;
        copy.crc32 = this.crc32;
        copy.compressedSize = this.compressedSize;
        copy.uncompressedSize = this.uncompressedSize;
        copy.fileNameLength = this.fileNameLength;
        copy.extraFieldLength = this.extraFieldLength;
        copy.fileName = this.fileName.copy();
        copy.extraField = this.extraField.copy();
        copy.fileData = this.fileData.copy();
        return copy;
    }

    @Override
    public void read(@Nonnull MemorySegment data, long offset) throws ZipParseException {
        super.read(data, offset);
        try {
            this.versionNeededToExtract = MemorySegmentUtil.readWord(data, offset, 4);
            this.generalPurposeBitFlag = MemorySegmentUtil.readWord(data, offset, 6);
            this.compressionMethod = MemorySegmentUtil.readWord(data, offset, 8);
            this.lastModFileTime = MemorySegmentUtil.readWord(data, offset, 10);
            this.lastModFileDate = MemorySegmentUtil.readWord(data, offset, 12);
            this.crc32 = MemorySegmentUtil.readQuad(data, offset, 14);
            this.compressedSize = MemorySegmentUtil.readMaskedLongQuad(data, offset, 18);
            this.uncompressedSize = MemorySegmentUtil.readMaskedLongQuad(data, offset, 22);
            this.fileNameLength = MemorySegmentUtil.readWord(data, offset, 26);
            this.extraFieldLength = MemorySegmentUtil.readWord(data, offset, 28);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ZipParseException(ex, ZipParseException.Type.IOOBE_OTHER);
        }
        catch (Throwable t) {
            throw new ZipParseException(t, ZipParseException.Type.OTHER);
        }
        try {
            this.fileName = StringData.of(data, offset + 30L, this.fileNameLength);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ZipParseException(ex, ZipParseException.Type.IOOBE_FILE_NAME);
        }
        catch (Throwable t) {
            throw new ZipParseException(t, ZipParseException.Type.OTHER);
        }
        try {
            this.extraField = MemorySegmentData.of(data, offset + 30L + (long)this.fileNameLength, this.extraFieldLength);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ZipParseException(ex, ZipParseException.Type.IOOBE_FILE_EXTRA);
        }
        catch (Throwable t) {
            throw new ZipParseException(t, ZipParseException.Type.OTHER);
        }
        long fileDataLength = this.compressionMethod == 0 ? this.uncompressedSize : this.compressedSize;
        try {
            this.fileData = MemorySegmentData.of(MemorySegmentUtil.readLongSlice(data, offset, 30 + this.fileNameLength + this.extraFieldLength, fileDataLength));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ZipParseException(ex, ZipParseException.Type.IOOBE_FILE_DATA);
        }
        catch (Throwable t) {
            throw new ZipParseException(t, ZipParseException.Type.OTHER);
        }
    }

    @Override
    public int getFileNameLength() {
        return super.getFileNameLength();
    }

    @Override
    public StringData getFileName() {
        return super.getFileName();
    }

    @Override
    public String getFileNameAsString() {
        return super.getFileNameAsString();
    }

    public boolean hasDifferentValuesThanCentralDirectoryHeader() {
        if (this.linkedDirectoryFileHeader == null) {
            return false;
        }
        if (this.getVersionNeededToExtract() != this.linkedDirectoryFileHeader.getVersionNeededToExtract()) {
            return true;
        }
        if (this.getGeneralPurposeBitFlag() != this.linkedDirectoryFileHeader.getGeneralPurposeBitFlag()) {
            return true;
        }
        if (this.getCompressionMethod() != this.linkedDirectoryFileHeader.getCompressionMethod()) {
            return true;
        }
        if (this.getLastModFileTime() != this.linkedDirectoryFileHeader.getLastModFileTime()) {
            return true;
        }
        if (this.getLastModFileDate() != this.linkedDirectoryFileHeader.getLastModFileDate()) {
            return true;
        }
        if (this.getCrc32() != this.linkedDirectoryFileHeader.getCrc32()) {
            return true;
        }
        if (this.getCompressedSize() != this.linkedDirectoryFileHeader.getCompressedSize()) {
            return true;
        }
        if (this.getUncompressedSize() != this.linkedDirectoryFileHeader.getUncompressedSize()) {
            return true;
        }
        if (this.getFileNameLength() != this.linkedDirectoryFileHeader.getFileNameLength()) {
            return true;
        }
        return !Objects.equals(this.getFileNameAsString(), this.linkedDirectoryFileHeader.getFileNameAsString());
    }

    public void adoptLinkedCentralDirectoryValues() throws ZipParseException {
        if (this.linkedDirectoryFileHeader != null) {
            long fileDataLength;
            this.versionNeededToExtract = this.linkedDirectoryFileHeader.versionNeededToExtract;
            this.generalPurposeBitFlag = this.linkedDirectoryFileHeader.generalPurposeBitFlag;
            this.compressionMethod = this.linkedDirectoryFileHeader.compressionMethod;
            this.lastModFileTime = this.linkedDirectoryFileHeader.lastModFileTime;
            this.lastModFileDate = this.linkedDirectoryFileHeader.lastModFileDate;
            this.crc32 = this.linkedDirectoryFileHeader.crc32;
            this.compressedSize = this.linkedDirectoryFileHeader.compressedSize;
            this.uncompressedSize = this.linkedDirectoryFileHeader.uncompressedSize;
            this.fileNameLength = this.linkedDirectoryFileHeader.fileNameLength;
            this.fileName = this.linkedDirectoryFileHeader.fileName;
            this.extraField = this.linkedDirectoryFileHeader.extraField;
            long l = fileDataLength = this.compressionMethod == 0 ? this.uncompressedSize : this.compressedSize;
            if (this.data != null) {
                try {
                    this.fileData = MemorySegmentData.of(MemorySegmentUtil.readLongSlice(this.data, this.offset, 30 + this.fileNameLength + this.extraFieldLength, fileDataLength));
                }
                catch (IndexOutOfBoundsException ex) {
                    throw new ZipParseException(ex, ZipParseException.Type.IOOBE_FILE_DATA);
                }
            }
        }
    }

    public void setFileDataEndOffset(long endOffset) {
        long fileDataStartOffset = this.offset + 30L + (long)this.fileNameLength + (long)this.extraFieldLength;
        long length = endOffset - fileDataStartOffset;
        this.setFileDataLength(length);
    }

    public void setFileDataLength(long newLength) {
        this.fileData = MemorySegmentData.of(MemorySegmentUtil.readLongSlice(this.data, this.offset, 30 + this.fileNameLength + this.extraFieldLength, newLength));
    }

    @Override
    public long length() {
        return (long)(30 + this.fileNameLength + this.extraFieldLength) + this.fileData.length();
    }

    @Override
    @Nonnull
    public PartType type() {
        return PartType.LOCAL_FILE_HEADER;
    }

    public MemorySegment decompress(Decompressor decompressor) throws IOException {
        return decompressor.decompress(this, this.fileData.get());
    }

    public CentralDirectoryFileHeader getLinkedDirectoryFileHeader() {
        return this.linkedDirectoryFileHeader;
    }

    public void link(CentralDirectoryFileHeader directoryFileHeader) {
        this.linkedDirectoryFileHeader = directoryFileHeader;
    }

    public MemorySegment getFileData() {
        return this.fileData.get();
    }

    public void setFileData(MemorySegmentData fileData) {
        this.fileData = fileData;
    }

    public String toString() {
        return "LocalFileHeader{fileData=" + String.valueOf(this.fileData) + ", data=" + String.valueOf(this.data) + ", versionNeededToExtract=" + this.versionNeededToExtract + ", generalPurposeBitFlag=" + this.generalPurposeBitFlag + ", compressionMethod=" + this.compressionMethod + ", lastModFileTime=" + this.lastModFileTime + ", lastModFileDate=" + this.lastModFileDate + ", crc32=" + this.crc32 + ", compressedSize=" + this.compressedSize + ", uncompressedSize=" + this.uncompressedSize + ", fileNameLength=" + this.fileNameLength + ", extraFieldLength=" + this.extraFieldLength + ", fileName='" + this.getFileNameAsString() + "', extraField='" + this.getExtraFieldAsString() + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalFileHeader)) {
            return false;
        }
        LocalFileHeader that = (LocalFileHeader)o;
        if (!super.equals(o)) {
            return false;
        }
        if (!Objects.equals(this.linkedDirectoryFileHeader, that.linkedDirectoryFileHeader)) {
            return false;
        }
        return Objects.equals(this.fileData, that.fileData);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.linkedDirectoryFileHeader != null ? this.linkedDirectoryFileHeader.hashCode() : 0);
        result = 31 * result + (this.fileData != null ? this.fileData.hashCode() : 0);
        return result;
    }
}

