/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.read;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import java.util.HashSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.coley.lljzip.format.ZipPatterns;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.EndOfCentralDirectory;
import software.coley.lljzip.format.model.JvmLocalFileHeader;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.model.ZipParseException;
import software.coley.lljzip.format.read.AbstractZipReader;
import software.coley.lljzip.format.read.JvmZipPartAllocator;
import software.coley.lljzip.format.read.ZipPartAllocator;
import software.coley.lljzip.util.MemorySegmentUtil;
import software.coley.lljzip.util.OffsetComparator;

public class JvmZipReader
extends AbstractZipReader {
    private static final Logger logger = LoggerFactory.getLogger(JvmZipReader.class);
    private final boolean skipRevisitedCenToLocalLinks;
    private final boolean allowBasicJvmBaseOffsetZeroCheck;

    public JvmZipReader() {
        this(new JvmZipPartAllocator(), true, true);
    }

    public JvmZipReader(boolean skipRevisitedCenToLocalLinks, boolean allowBasicJvmBaseOffsetZeroCheck) {
        this(new JvmZipPartAllocator(), skipRevisitedCenToLocalLinks, allowBasicJvmBaseOffsetZeroCheck);
    }

    public JvmZipReader(@Nonnull ZipPartAllocator allocator, boolean skipRevisitedCenToLocalLinks, boolean allowBasicJvmBaseOffsetZeroCheck) {
        super(allocator);
        this.skipRevisitedCenToLocalLinks = skipRevisitedCenToLocalLinks;
        this.allowBasicJvmBaseOffsetZeroCheck = allowBasicJvmBaseOffsetZeroCheck;
    }

    @Override
    public void read(@Nonnull ZipArchive zip, @Nonnull MemorySegment data) throws IOException {
        long firstOffset;
        long offset;
        long endOfCentralDirectoryOffset = MemorySegmentUtil.lastIndexOfQuad(data, data.byteSize() - 4L, 101010256);
        if (endOfCentralDirectoryOffset < 0L) {
            throw new IOException("No Central-Directory-File-Header found!");
        }
        long precedingEndOfCentralDirectory = MemorySegmentUtil.lastIndexOfQuad(data, endOfCentralDirectoryOffset - 1L, 101010256);
        EndOfCentralDirectory end = this.newEndOfCentralDirectory();
        end.read(data, endOfCentralDirectoryOffset);
        zip.addPart(end);
        long len = data.byteSize();
        long centralDirectoryOffsetScanEnd = Math.max(Math.max(precedingEndOfCentralDirectory, 0L), end.getCentralDirectoryOffset());
        long earliestCentralDirectoryOffset = len - (long)ZipPatterns.CENTRAL_DIRECTORY_FILE_HEADER.length;
        long maxRelativeOffset = 0L;
        while ((offset = MemorySegmentUtil.lastIndexOfQuad(data, earliestCentralDirectoryOffset - 1L, 33639248)) >= centralDirectoryOffsetScanEnd) {
            earliestCentralDirectoryOffset = offset;
        }
        long centralDirectoryOffset = earliestCentralDirectoryOffset;
        while (centralDirectoryOffset >= 0L) {
            CentralDirectoryFileHeader directory = this.newCentralDirectoryFileHeader();
            try {
                directory.read(data, centralDirectoryOffset);
            }
            catch (ZipParseException ex) {
                throw new IOException(ex);
            }
            zip.addPart(directory);
            if (directory.getRelativeOffsetOfLocalHeader() > maxRelativeOffset) {
                maxRelativeOffset = directory.getRelativeOffsetOfLocalHeader();
            }
            centralDirectoryOffset = MemorySegmentUtil.indexOfQuad(data, centralDirectoryOffset + 46L, 33639248);
        }
        long jvmBaseFileOffset = 0L;
        boolean priorZipEndWasBogus = false;
        if (precedingEndOfCentralDirectory != -1L) {
            try {
                EndOfCentralDirectory tempEnd = new EndOfCentralDirectory();
                tempEnd.read(data, precedingEndOfCentralDirectory);
                long hypotheticalJvmBaseOffset = precedingEndOfCentralDirectory + tempEnd.length();
                if (len <= hypotheticalJvmBaseOffset + maxRelativeOffset) {
                    throw new IllegalStateException();
                }
                jvmBaseFileOffset = precedingEndOfCentralDirectory + tempEnd.length();
            }
            catch (Exception ex) {
                priorZipEndWasBogus = true;
            }
        }
        if (!(!priorZipEndWasBogus && precedingEndOfCentralDirectory != -1L || this.allowBasicJvmBaseOffsetZeroCheck && MemorySegmentUtil.readQuad(data, 0L) == 67324752 && MemorySegmentUtil.indexOfQuad(data, 1L, 67324752) > 30L)) {
            long endPos = end.offset();
            long cenLen = end.getCentralDirectorySize();
            long cenOff = end.getCentralDirectoryOffset();
            jvmBaseFileOffset = endPos - cenLen - cenOff;
            jvmBaseFileOffset = MemorySegmentUtil.indexOfWord(data, jvmBaseFileOffset, 19280);
            while (jvmBaseFileOffset >= 0L) {
                try {
                    if (MemorySegmentUtil.readQuad(data, jvmBaseFileOffset) != 67324752 && MemorySegmentUtil.readQuad(data, jvmBaseFileOffset) != 33639248) {
                        throw new IllegalStateException("No match for LocalFileHeader/CentralDirectoryFileHeader");
                    }
                    break;
                }
                catch (Exception ex) {
                    jvmBaseFileOffset = MemorySegmentUtil.indexOfWord(data, jvmBaseFileOffset + 1L, 19280);
                }
            }
        }
        jvmBaseFileOffset = Math.max(0L, jvmBaseFileOffset);
        HashSet<Long> offsets = new HashSet<Long>();
        TreeSet<Long> entryOffsets = new TreeSet<Long>();
        long earliestCdfh = Long.MAX_VALUE;
        for (CentralDirectoryFileHeader directory : zip.getCentralDirectories()) {
            long offset2;
            if (directory.offset() < earliestCdfh) {
                earliestCdfh = directory.offset();
            }
            if ((offset2 = jvmBaseFileOffset + directory.getRelativeOffsetOfLocalHeader()) < 0L || offset2 >= len - 4L || MemorySegmentUtil.readQuad(data, offset2) != 67324752) continue;
            entryOffsets.add(offset2);
        }
        entryOffsets.add(earliestCdfh);
        entryOffsets.add(endOfCentralDirectoryOffset);
        for (CentralDirectoryFileHeader directory : zip.getCentralDirectories()) {
            long relative = directory.getRelativeOffsetOfLocalHeader();
            long offset3 = jvmBaseFileOffset + relative;
            boolean isNewOffset = offsets.add(offset3);
            if (!isNewOffset) {
                logger.warn("Central-Directory-File-Header's offset[{}] was already visited", (Object)offset3);
                if (this.skipRevisitedCenToLocalLinks) continue;
            }
            if (offset3 >= 0L && offset3 <= len - 4L && MemorySegmentUtil.readQuad(data, offset3) != 67324752) {
                logger.warn("Central-Directory-File-Header's offset[{}] to Local-File-Header does not match the Local-File-Header magic!", (Object)offset3);
                continue;
            }
            try {
                LocalFileHeader file = this.newLocalFileHeader();
                if (file instanceof JvmLocalFileHeader) {
                    JvmLocalFileHeader jvmFile = (JvmLocalFileHeader)file;
                    jvmFile.setOffsets(entryOffsets);
                }
                try {
                    if (offset3 <= len - 30L) {
                        file.read(data, offset3);
                    }
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
                directory.link(file);
                file.link(directory);
                file.adoptLinkedCentralDirectoryValues();
                zip.addPart(file);
                this.postProcessLocalFileHeader(file);
            }
            catch (Exception ex) {
                logger.warn("Failed to read 'local file header' at offset[{}]", (Object)offset3, (Object)ex);
            }
        }
        if (!entryOffsets.isEmpty() && (firstOffset = ((Long)entryOffsets.first()).longValue()) > 0L) {
            zip.setPrefixData(data.asSlice(0L, firstOffset));
        }
        zip.sortParts(new OffsetComparator());
    }
}

