/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.read;

import java.io.IOException;
import java.lang.foreign.MemorySegment;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.model.ZipParseException;
import software.coley.lljzip.format.read.AbstractZipReader;
import software.coley.lljzip.format.read.SimpleZipPartAllocator;
import software.coley.lljzip.format.read.ZipPartAllocator;
import software.coley.lljzip.util.MemorySegmentUtil;

public class NaiveLocalFileZipReader
extends AbstractZipReader {
    public NaiveLocalFileZipReader() {
        super(new SimpleZipPartAllocator());
    }

    public NaiveLocalFileZipReader(@Nonnull ZipPartAllocator allocator) {
        super(allocator);
    }

    @Override
    public void read(@Nonnull ZipArchive zip, @Nonnull MemorySegment data) throws IOException {
        long localFileOffset = MemorySegmentUtil.indexOfQuad(data, 0L, 67324752);
        if (localFileOffset < 0L) {
            return;
        }
        if (localFileOffset > 0L) {
            zip.setPrefixData(data.asSlice(0L, localFileOffset));
        }
        do {
            LocalFileHeader file = this.newLocalFileHeader();
            try {
                file.read(data, localFileOffset);
            }
            catch (ZipParseException ex) {
                throw new IOException(ex);
            }
            zip.addPart(file);
            this.postProcessLocalFileHeader(file);
        } while ((localFileOffset = MemorySegmentUtil.indexOfQuad(data, localFileOffset + 1L, 67324752)) >= 0L);
    }
}

