/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import javax.annotation.Nonnull;

public class MemorySegmentInputStream
extends InputStream {
    private final MemorySegment data;
    private long read;
    private long markedOffset = -1L;
    private long markedLimit;
    private volatile boolean closed;

    public MemorySegmentInputStream(@Nonnull MemorySegment data) {
        this.data = data;
    }

    @Nonnull
    public MemorySegment getData() {
        return this.data;
    }

    public long getRead() {
        return this.read;
    }

    public long getMarkedOffset() {
        return this.markedOffset;
    }

    public long getMarkedLimit() {
        return this.markedLimit;
    }

    public boolean isClosed() {
        return this.closed;
    }

    private void checkMarkLimit() {
        long diff;
        if (this.markedOffset > -1L && (diff = this.read - this.markedOffset) > this.markedLimit) {
            this.markedOffset = -1L;
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int limit) {
        this.markedOffset = this.read;
        this.markedLimit = limit;
    }

    @Override
    public synchronized void reset() {
        this.read = this.markedOffset;
    }

    @Override
    public int read() throws IOException {
        this.ensureOpen();
        MemorySegment data = this.data;
        if (this.read >= data.byteSize()) {
            return -1;
        }
        byte b = data.get(ValueLayout.JAVA_BYTE, this.read++);
        this.checkMarkLimit();
        return b & 0xFF;
    }

    @Override
    public int read(@Nonnull byte[] b, int off, int len) throws IOException {
        this.ensureOpen();
        MemorySegment data = this.data;
        long read = this.read;
        long length = data.byteSize();
        if (read >= length) {
            return -1;
        }
        long remaining = length - read;
        len = (int)Math.min(remaining, (long)len);
        MemorySegment.copy(data, read, MemorySegment.ofArray(b), off, len);
        this.read += (long)len;
        this.checkMarkLimit();
        return len;
    }

    @Override
    public byte[] readNBytes(int len) throws IOException {
        this.ensureOpen();
        MemorySegment data = this.data;
        long read = this.read;
        long length = data.byteSize();
        if (read >= length) {
            return new byte[0];
        }
        long remaining = length - read;
        len = (int)Math.min(remaining, (long)len);
        byte[] buf = new byte[len];
        MemorySegment.copy(data, read, MemorySegment.ofArray(buf), 0L, len);
        this.read += (long)len;
        this.checkMarkLimit();
        return buf;
    }

    @Override
    public long skip(long n) throws IOException {
        this.ensureOpen();
        MemorySegment data = this.data;
        long read = this.read;
        long length = data.byteSize();
        if (read >= length) {
            return 0L;
        }
        n = Math.min(n, length - read);
        this.read += n;
        this.checkMarkLimit();
        return n;
    }

    @Override
    public int available() throws IOException {
        this.ensureOpen();
        MemorySegment data = this.data;
        long length = data.byteSize();
        long read = this.read;
        if (read >= length) {
            return 0;
        }
        long remaining = length - read;
        if (remaining > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)remaining;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public long transferTo(OutputStream out) throws IOException {
        int copyable;
        long read;
        this.ensureOpen();
        MemorySegment data = this.data;
        long length = data.byteSize();
        if (read >= length) {
            return 0L;
        }
        long remaining = length - read;
        byte[] buffer = new byte[(int)Math.min(16384L, remaining)];
        MemorySegment bufferSegment = MemorySegment.ofArray(buffer);
        for (read = this.read; read < length; read += (long)copyable) {
            copyable = (int)Math.min((long)buffer.length, length - read);
            MemorySegment.copy(data, read, bufferSegment, 0L, copyable);
            out.write(buffer, 0, copyable);
        }
        this.read = length;
        this.checkMarkLimit();
        return remaining;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }
}

