/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;

public class MemorySegmentUtil {
    public static final int WILDCARD = Integer.MIN_VALUE;
    public static final MemorySegment EMPTY = MemorySegment.ofArray(new byte[0]);
    private static final ValueLayout.OfInt LITTLE_INT = ValueLayout.JAVA_INT_UNALIGNED.withOrder(ByteOrder.LITTLE_ENDIAN);
    private static final ValueLayout.OfShort LITTLE_SHORT = ValueLayout.JAVA_SHORT_UNALIGNED.withOrder(ByteOrder.LITTLE_ENDIAN);

    public static long indexOfWord(MemorySegment data, long offset, int pattern) {
        if (offset < 0L) {
            return -1L;
        }
        long len = data.byteSize() - 2L;
        for (long i = offset; i < len; ++i) {
            if (pattern != (data.get(LITTLE_SHORT, i) & 0xFFFF)) continue;
            return i;
        }
        return -1L;
    }

    public static long indexOfQuad(MemorySegment data, long offset, int pattern) {
        if (offset < 0L) {
            return -1L;
        }
        long len = data.byteSize() - 4L;
        long i = offset;
        while (i < len) {
            int value = data.get(LITTLE_INT, i);
            if (pattern == value) {
                return i;
            }
            if ((pattern & 0xFFFFFF) == (value & 0xFFFFFF00) >>> 8) {
                ++i;
                continue;
            }
            if ((pattern & 0xFFFF) == (value & 0xFFFF0000) >>> 16) {
                i += 2L;
                continue;
            }
            if ((pattern & 0xFF) == (value & 0xFF000000) >>> 24) {
                i += 3L;
                continue;
            }
            i += 4L;
        }
        return -1L;
    }

    public static long lastIndexOfWord(MemorySegment data, long offset, int pattern) {
        long limit;
        if (offset < 0L || data == null || (limit = data.byteSize()) < 2L || offset >= limit) {
            return -1L;
        }
        for (long i = offset; i >= 0L; --i) {
            if (pattern != data.get(LITTLE_SHORT, i)) continue;
            return i;
        }
        return -1L;
    }

    public static long lastIndexOfQuad(MemorySegment data, long offset, int pattern) {
        long limit;
        if (offset < 0L || data == null || (limit = data.byteSize()) < 4L || offset >= limit) {
            return -1L;
        }
        long i = offset;
        while (i >= 0L) {
            int value = data.get(LITTLE_INT, i);
            if (pattern == value) {
                return i;
            }
            if ((pattern & 0xFFFFFF00) >>> 8 == (value & 0xFFFFFF)) {
                --i;
                continue;
            }
            if ((pattern & 0xFFFF0000) >>> 16 == (value & 0xFFFF)) {
                i -= 2L;
                continue;
            }
            if ((pattern & 0xFFFFFF00) >>> 24 == (value & 0xFF)) {
                i -= 3L;
                continue;
            }
            i -= 4L;
        }
        return -1L;
    }

    public static long indexOf(MemorySegment data, int[] pattern) {
        return MemorySegmentUtil.indexOf(data, 0L, pattern);
    }

    public static long indexOf(MemorySegment data, long offset, int[] pattern) {
        long limit;
        if (offset < 0L || data == null || (limit = data.byteSize()) < (long)pattern.length || offset >= limit) {
            return -1L;
        }
        for (long i = offset; i < limit; ++i) {
            if (!MemorySegmentUtil.startsWith(data, i, pattern)) continue;
            return i;
        }
        return -1L;
    }

    public static long lastIndexOf(MemorySegment data, int[] pattern) {
        return MemorySegmentUtil.lastIndexOf(data, data.byteSize() - (long)pattern.length, pattern);
    }

    public static long lastIndexOf(MemorySegment data, long offset, int[] pattern) {
        if (offset < 0L || data == null || data.byteSize() < (long)pattern.length) {
            return -1L;
        }
        for (long i = offset; i >= 0L; --i) {
            if (!MemorySegmentUtil.startsWith(data, i, pattern)) continue;
            return i;
        }
        return -1L;
    }

    public static boolean startsWith(MemorySegment data, long offset, int[] pattern) {
        if (data == null || data.byteSize() - offset < (long)pattern.length || offset < 0L || offset >= data.byteSize()) {
            return false;
        }
        for (int i = 0; i < pattern.length; ++i) {
            int p = pattern[i];
            if (p == Integer.MIN_VALUE || (data.get(ValueLayout.JAVA_BYTE, offset + (long)i) & 0xFF) == p) continue;
            return false;
        }
        return true;
    }

    public static int readWord(MemorySegment data, long i) {
        return data.get(LITTLE_SHORT, i) & 0xFFFF;
    }

    public static int readQuad(MemorySegment data, long i) {
        return data.get(LITTLE_INT, i);
    }

    public static String readString(MemorySegment data, long start, long len) {
        if (len == 0L) {
            return "";
        }
        byte[] bytes = data.asSlice(start, len).toArray(ValueLayout.JAVA_BYTE);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    public static byte[] readArray(MemorySegment data, long start, long len) {
        return data.asSlice(start, len).toArray(ValueLayout.JAVA_BYTE);
    }

    public static byte[] toByteArray(MemorySegment data) {
        long length = data.byteSize();
        if (length > 0x7FFFFFF7L) {
            throw new IllegalStateException("Data too big!");
        }
        return data.toArray(ValueLayout.JAVA_BYTE);
    }

    public static String toString(MemorySegment data) {
        return new String(MemorySegmentUtil.toByteArray(data), StandardCharsets.UTF_8);
    }

    public static int readWord(MemorySegment data, long headerOffset, int localOffset) {
        return MemorySegmentUtil.readWord(data, headerOffset + (long)localOffset);
    }

    public static int readQuad(MemorySegment data, long headerOffset, int localOffset) {
        return MemorySegmentUtil.readQuad(data, headerOffset + (long)localOffset);
    }

    public static int readMaskedQuad(MemorySegment data, long headerOffset, int localOffset) {
        return MemorySegmentUtil.readQuad(data, headerOffset + (long)localOffset) & 0xFFFF;
    }

    public static long readLongWord(MemorySegment data, long headerOffset, int localOffset) {
        return MemorySegmentUtil.readWord(data, headerOffset + (long)localOffset);
    }

    public static long readMaskedLongQuad(MemorySegment data, long headerOffset, int localOffset) {
        return (long)MemorySegmentUtil.readQuad(data, headerOffset + (long)localOffset) & 0xFFFFFFFFL;
    }

    public static MemorySegment readSlice(MemorySegment data, long headerOffset, int localOffset, int length) {
        return data.asSlice(headerOffset + (long)localOffset, length);
    }

    public static MemorySegment readLongSlice(MemorySegment data, long headerOffset, int localOffset, long length) {
        return data.asSlice(headerOffset + (long)localOffset, length);
    }

    public static MemorySegment readLongSlice(MemorySegment data, long headerOffset, long localOffset, long length) {
        return data.asSlice(headerOffset + localOffset, length);
    }
}

