/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.read.AdaptingZipReader;
import software.coley.lljzip.format.read.ForwardScanZipReader;
import software.coley.lljzip.format.read.JvmZipReader;
import software.coley.lljzip.format.read.NaiveLocalFileZipReader;
import software.coley.lljzip.format.read.ZipReader;

public class ZipIO {
    public static ZipArchive readStandard(MemorySegment data) throws IOException {
        return ZipIO.read(data, (ZipReader)new ForwardScanZipReader());
    }

    public static ZipArchive readStandard(byte[] data) throws IOException {
        return ZipIO.read(data, (ZipReader)new ForwardScanZipReader());
    }

    public static ZipArchive readStandard(Path data) throws IOException {
        return ZipIO.read(data, (ZipReader)new ForwardScanZipReader());
    }

    public static ZipArchive readNaive(MemorySegment data) throws IOException {
        return ZipIO.read(data, (ZipReader)new NaiveLocalFileZipReader());
    }

    public static ZipArchive readNaive(byte[] data) throws IOException {
        return ZipIO.read(data, (ZipReader)new NaiveLocalFileZipReader());
    }

    public static ZipArchive readNaive(Path data) throws IOException {
        return ZipIO.read(data, (ZipReader)new NaiveLocalFileZipReader());
    }

    public static ZipArchive readJvm(MemorySegment data) throws IOException {
        return ZipIO.read(data, (ZipReader)new JvmZipReader());
    }

    public static ZipArchive readJvm(byte[] data) throws IOException {
        return ZipIO.read(data, (ZipReader)new JvmZipReader());
    }

    public static ZipArchive readJvm(Path path) throws IOException {
        return ZipIO.read(path, (ZipReader)new JvmZipReader());
    }

    public static ZipArchive readAdaptingIO(Path path) throws IOException {
        ZipArchive archive = new ZipArchive();
        AdaptingZipReader.fill(archive, path.toFile());
        return archive;
    }

    public static ZipArchive read(byte[] data, ZipReader strategy) throws IOException {
        if (data == null) {
            throw new IOException("Data is null!");
        }
        return ZipIO.read(MemorySegment.ofArray(data), strategy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ZipArchive read(Path path, ZipReader strategy) throws IOException {
        if (path == null) {
            throw new IOException("Data is null!");
        }
        if (!Files.isRegularFile(path, new LinkOption[0])) {
            throw new FileNotFoundException(path.toString());
        }
        try (FileChannel fc = FileChannel.open(path, new OpenOption[0]);){
            long size = fc.size();
            if (size < 22L) {
                throw new IOException("Not enough bytes to read Central-Directory-File-Header, minimum=22");
            }
            ZipArchive zip = new ZipArchive(fc);
            strategy.read(zip, fc.map(FileChannel.MapMode.READ_ONLY, 0L, size, Arena.ofAuto()));
            fc = null;
            ZipArchive zipArchive = zip;
            return zipArchive;
        }
    }

    public static ZipArchive read(MemorySegment data, ZipReader strategy) throws IOException {
        if (data == null) {
            throw new IOException("Data is null!");
        }
        if (data.byteSize() < 22L) {
            throw new IOException("Not enough bytes to read Central-Directory-File-Header, minimum=22");
        }
        ZipArchive zip = new ZipArchive();
        strategy.read(zip, data);
        return zip;
    }
}

