/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.util.MemorySegmentUtil;
import software.coley.lljzip.util.data.MemorySegmentData;
import software.coley.lljzip.util.data.StringData;

public class AdaptingLocalFileHeader
extends LocalFileHeader {
    private static final int BUFFER_SIZE = 2048;

    public AdaptingLocalFileHeader(@Nonnull ZipFile archive, @Nonnull ZipEntry entry) throws IOException {
        int read;
        InputStream inputStream = archive.getInputStream(entry);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        while ((read = inputStream.read(buffer)) != -1) {
            outputStream.write(buffer, 0, read);
        }
        byte[] entryData = outputStream.toByteArray();
        String entryName = entry.getName();
        byte[] extra = entry.getExtra();
        this.fileNameLength = entryName.length();
        this.fileName = StringData.of(entryName);
        this.fileData = MemorySegmentData.of(entryData);
        this.compressionMethod = 0;
        this.uncompressedSize = entryData.length;
        this.compressedSize = entryData.length;
        this.crc32 = (int)entry.getCrc();
        if (extra != null && extra.length > 0) {
            this.extraFieldLength = extra.length;
            this.extraField = MemorySegmentData.of(extra);
        } else {
            this.extraFieldLength = 0;
            this.extraField = MemorySegmentData.empty();
        }
        this.data = MemorySegmentUtil.EMPTY;
    }
}

