/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.model;

import java.lang.foreign.MemorySegment;
import java.util.Objects;
import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.AbstractZipFileHeader;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.PartType;
import software.coley.lljzip.format.model.ZipParseException;
import software.coley.lljzip.util.MemorySegmentUtil;
import software.coley.lljzip.util.data.MemorySegmentData;
import software.coley.lljzip.util.data.StringData;

public class CentralDirectoryFileHeader
extends AbstractZipFileHeader {
    public static final long MIN_FIXED_SIZE = 46L;
    private transient LocalFileHeader linkedFileHeader;
    private int versionMadeBy;
    private int fileCommentLength;
    private StringData fileComment;
    private int diskNumberStart;
    private int internalFileAttributes;
    private int externalFileAttributes;
    private long relativeOffsetOfLocalHeader;

    @Nonnull
    public CentralDirectoryFileHeader copy() {
        CentralDirectoryFileHeader copy = new CentralDirectoryFileHeader();
        copy.data = this.data;
        copy.offset = this.offset;
        copy.linkedFileHeader = this.linkedFileHeader;
        copy.versionMadeBy = this.versionMadeBy;
        copy.versionNeededToExtract = this.versionNeededToExtract;
        copy.generalPurposeBitFlag = this.generalPurposeBitFlag;
        copy.compressionMethod = this.compressionMethod;
        copy.lastModFileTime = this.lastModFileTime;
        copy.lastModFileDate = this.lastModFileDate;
        copy.crc32 = this.crc32;
        copy.compressedSize = this.compressedSize;
        copy.uncompressedSize = this.uncompressedSize;
        copy.fileNameLength = this.fileNameLength;
        copy.extraFieldLength = this.extraFieldLength;
        copy.fileCommentLength = this.fileCommentLength;
        copy.diskNumberStart = this.diskNumberStart;
        copy.internalFileAttributes = this.internalFileAttributes;
        copy.externalFileAttributes = this.externalFileAttributes;
        copy.relativeOffsetOfLocalHeader = this.relativeOffsetOfLocalHeader;
        copy.fileName = this.fileName.copy();
        copy.extraField = this.extraField.copy();
        copy.fileComment = this.fileComment.copy();
        return copy;
    }

    @Override
    public void read(@Nonnull MemorySegment data, long offset) throws ZipParseException {
        super.read(data, offset);
        try {
            this.versionMadeBy = MemorySegmentUtil.readWord(data, offset, 4);
            this.versionNeededToExtract = MemorySegmentUtil.readWord(data, offset, 6);
            this.generalPurposeBitFlag = MemorySegmentUtil.readWord(data, offset, 8);
            this.compressionMethod = MemorySegmentUtil.readWord(data, offset, 10);
            this.lastModFileTime = MemorySegmentUtil.readWord(data, offset, 12);
            this.lastModFileDate = MemorySegmentUtil.readWord(data, offset, 14);
            this.crc32 = MemorySegmentUtil.readQuad(data, offset, 16);
            this.compressedSize = MemorySegmentUtil.readMaskedLongQuad(data, offset, 20);
            this.uncompressedSize = MemorySegmentUtil.readMaskedLongQuad(data, offset, 24);
            this.fileNameLength = MemorySegmentUtil.readWord(data, offset, 28);
            this.extraFieldLength = MemorySegmentUtil.readWord(data, offset, 30);
            this.fileCommentLength = MemorySegmentUtil.readWord(data, offset, 32);
            this.diskNumberStart = MemorySegmentUtil.readWord(data, offset, 34);
            this.internalFileAttributes = MemorySegmentUtil.readWord(data, offset, 36);
            this.externalFileAttributes = MemorySegmentUtil.readQuad(data, offset, 38);
            this.relativeOffsetOfLocalHeader = MemorySegmentUtil.readMaskedLongQuad(data, offset, 42);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ZipParseException(ex, ZipParseException.Type.IOOBE_OTHER);
        }
        catch (Throwable t) {
            throw new ZipParseException(t, ZipParseException.Type.OTHER);
        }
        try {
            this.fileName = StringData.of(data, offset + 46L, this.fileNameLength);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ZipParseException(ex, ZipParseException.Type.IOOBE_FILE_NAME);
        }
        catch (Throwable t) {
            throw new ZipParseException(t, ZipParseException.Type.OTHER);
        }
        try {
            this.extraField = MemorySegmentData.of(data, offset + 46L + (long)this.fileNameLength, this.extraFieldLength);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ZipParseException(ex, ZipParseException.Type.IOOBE_FILE_EXTRA);
        }
        catch (Throwable t) {
            throw new ZipParseException(t, ZipParseException.Type.OTHER);
        }
        try {
            this.fileComment = StringData.of(data, offset + 46L + (long)this.fileNameLength + (long)this.extraFieldLength, this.fileCommentLength);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ZipParseException(ex, ZipParseException.Type.IOOBE_CEN_COMMENT);
        }
        catch (Throwable t) {
            throw new ZipParseException(t, ZipParseException.Type.OTHER);
        }
    }

    @Override
    public long length() {
        return 46L + (long)this.fileNameLength + (long)this.extraFieldLength + (long)this.fileCommentLength;
    }

    @Override
    @Nonnull
    public PartType type() {
        return PartType.CENTRAL_DIRECTORY_FILE_HEADER;
    }

    @Override
    public int getFileNameLength() {
        return super.getFileNameLength();
    }

    @Override
    public StringData getFileName() {
        return super.getFileName();
    }

    @Override
    public String getFileNameAsString() {
        return super.getFileNameAsString();
    }

    public LocalFileHeader getLinkedFileHeader() {
        return this.linkedFileHeader;
    }

    public void link(LocalFileHeader header) {
        this.linkedFileHeader = header;
    }

    public int getVersionMadeBy() {
        return this.versionMadeBy;
    }

    public void setVersionMadeBy(int versionMadeBy) {
        this.versionMadeBy = versionMadeBy;
    }

    public int getDiskNumberStart() {
        return this.diskNumberStart;
    }

    public void setDiskNumberStart(int diskNumberStart) {
        this.diskNumberStart = diskNumberStart;
    }

    public int getInternalFileAttributes() {
        return this.internalFileAttributes;
    }

    public void setInternalFileAttributes(int internalFileAttributes) {
        this.internalFileAttributes = internalFileAttributes;
    }

    public int getExternalFileAttributes() {
        return this.externalFileAttributes;
    }

    public void setExternalFileAttributes(int externalFileAttributes) {
        this.externalFileAttributes = externalFileAttributes;
    }

    public long getRelativeOffsetOfLocalHeader() {
        return this.relativeOffsetOfLocalHeader;
    }

    public void setRelativeOffsetOfLocalHeader(long relativeOffsetOfLocalHeader) {
        this.relativeOffsetOfLocalHeader = relativeOffsetOfLocalHeader & 0xFFFFFFFFL;
    }

    public int getFileCommentLength() {
        return this.fileCommentLength;
    }

    public void setFileCommentLength(int fileCommentLength) {
        this.fileCommentLength = fileCommentLength & 0xFFFF;
    }

    public StringData getFileComment() {
        return this.fileComment;
    }

    public void setFileComment(StringData fileComment) {
        this.fileComment = fileComment;
    }

    public String getFileCommentAsString() {
        return this.fileComment.get();
    }

    public String toString() {
        return "CentralDirectoryFileHeader{  versionMadeBy=" + this.versionMadeBy + ", versionNeededToExtract=" + this.versionNeededToExtract + ", generalPurposeBitFlag=" + this.generalPurposeBitFlag + ", compressionMethod=" + this.compressionMethod + ", lastModFileTime=" + this.lastModFileTime + ", lastModFileDate=" + this.lastModFileDate + ", crc32=" + this.crc32 + ", compressedSize=" + this.compressedSize + ", uncompressedSize=" + this.uncompressedSize + ", fileNameLength=" + this.fileNameLength + ", extraFieldLength=" + this.extraFieldLength + ", fileCommentLength=" + this.fileCommentLength + ", diskNumberStart=" + this.diskNumberStart + ", internalFileAttributes=" + this.internalFileAttributes + ", externalFileAttributes=" + this.externalFileAttributes + ", relativeOffsetOfLocalHeader=" + this.relativeOffsetOfLocalHeader + ", fileName='" + this.getFileNameAsString() + "', extraField='" + this.getExtraFieldAsString() + "', fileComment='" + this.getFileCommentAsString() + "'}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CentralDirectoryFileHeader)) {
            return false;
        }
        CentralDirectoryFileHeader that = (CentralDirectoryFileHeader)o;
        if (!super.equals(o)) {
            return false;
        }
        if (this.versionMadeBy != that.versionMadeBy) {
            return false;
        }
        if (this.fileCommentLength != that.fileCommentLength) {
            return false;
        }
        if (this.diskNumberStart != that.diskNumberStart) {
            return false;
        }
        if (this.internalFileAttributes != that.internalFileAttributes) {
            return false;
        }
        if (this.externalFileAttributes != that.externalFileAttributes) {
            return false;
        }
        if (this.relativeOffsetOfLocalHeader != that.relativeOffsetOfLocalHeader) {
            return false;
        }
        if (!Objects.equals(this.linkedFileHeader, that.linkedFileHeader)) {
            return false;
        }
        return Objects.equals(this.fileComment, that.fileComment);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.linkedFileHeader != null ? this.linkedFileHeader.hashCode() : 0);
        result = 31 * result + this.versionMadeBy;
        result = 31 * result + this.fileCommentLength;
        result = 31 * result + (this.fileComment != null ? this.fileComment.hashCode() : 0);
        result = 31 * result + this.diskNumberStart;
        result = 31 * result + this.internalFileAttributes;
        result = 31 * result + this.externalFileAttributes;
        result = 31 * result + (int)(this.relativeOffsetOfLocalHeader ^ this.relativeOffsetOfLocalHeader >>> 32);
        return result;
    }
}

