/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.format.transform;

import javax.annotation.Nonnull;
import software.coley.lljzip.format.model.CentralDirectoryFileHeader;
import software.coley.lljzip.format.model.LocalFileHeader;
import software.coley.lljzip.format.model.ZipArchive;
import software.coley.lljzip.format.transform.DelegatingZipPartMapper;
import software.coley.lljzip.format.transform.ZipPartMapper;

public class JvmClassDirectoryMapper
extends DelegatingZipPartMapper {
    public JvmClassDirectoryMapper(@Nonnull ZipPartMapper delegate) {
        super(delegate);
    }

    @Override
    @Nonnull
    public LocalFileHeader mapLocal(@Nonnull ZipArchive archive, @Nonnull LocalFileHeader localFileHeader) {
        String name = localFileHeader.getFileNameAsString();
        if (name.endsWith(".class/")) {
            int newLength = name.length() - 1;
            LocalFileHeader copy = localFileHeader.copy();
            copy.setFileName(copy.getFileName().substring(0, newLength));
            copy.setFileNameLength(newLength);
            localFileHeader = copy;
        }
        return super.mapLocal(archive, localFileHeader);
    }

    @Override
    @Nonnull
    public CentralDirectoryFileHeader mapCentral(@Nonnull ZipArchive archive, @Nonnull CentralDirectoryFileHeader centralDirectoryFileHeader) {
        String name = centralDirectoryFileHeader.getFileNameAsString();
        if (name.endsWith(".class/")) {
            int newLength = name.length() - 1;
            CentralDirectoryFileHeader copy = centralDirectoryFileHeader.copy();
            copy.setFileName(copy.getFileName().substring(0, newLength));
            copy.setFileNameLength(newLength);
            centralDirectoryFileHeader = copy;
        }
        return super.mapCentral(archive, centralDirectoryFileHeader);
    }
}

