/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Field;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import software.coley.lljzip.format.compression.DeflateEntry;
import software.coley.lljzip.util.UnsafeUtil;
import sun.misc.Unsafe;

public final class InflaterHackery {
    public static final boolean NEW_INFLATE;
    private static final Unsafe UNSAFE;
    private static final MethodHandle INFLATE;
    private static final MethodHandle MH_RESET;
    private static final MethodHandle MH_FINISHED;
    private static final long zRef_offset;
    private static final long zRef_address_offset;

    private InflaterHackery() {
    }

    public static void reset(Inflater inflater) {
        Unsafe u = UNSAFE;
        long address = u.getLong(u.getObject(inflater, zRef_offset), zRef_address_offset);
        try {
            MH_RESET.invokeExact(address);
            if (!NEW_INFLATE) {
                MH_FINISHED.invokeExact(inflater, false);
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static int inflate(DeflateEntry entry, byte[] in, int len, byte[] out) throws DataFormatException {
        try {
            Inflater inflater = entry.inflater;
            if (NEW_INFLATE) {
                Unsafe u = UNSAFE;
                long address = u.getLong(u.getObject(inflater, zRef_offset), zRef_address_offset);
                int offset = entry.offset;
                long packed = INFLATE.invokeExact(inflater, address, in, offset, len - offset, out, 0, out.length);
                int read = (int)(packed & Integer.MAX_VALUE);
                int written = (int)(packed >>> 31 & Integer.MAX_VALUE);
                int finished = (int)(packed >>> 62 & 1L);
                if (finished == 0 && written == 0 && len == offset) {
                    finished = 1;
                }
                int newOffset = offset + read;
                entry.state = finished << 1 | newOffset - in.length >>> 31 ^ 1;
                entry.offset = newOffset;
                return written;
            }
            int written = inflater.inflate(out);
            boolean finished = inflater.finished();
            if (!finished && written == 0 && len == entry.offset) {
                finished = true;
            }
            entry.state = finished ? 2 : (written == 0 ? 1 : 0);
            return written;
        }
        catch (OutOfMemoryError | StackOverflowError | DataFormatException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    static {
        UNSAFE = UnsafeUtil.get();
        try {
            MethodHandle inflate;
            Unsafe u = UNSAFE;
            Field f = Inflater.class.getDeclaredField("zsRef");
            Class<?> zrefClass = f.getType();
            zRef_offset = u.objectFieldOffset(f);
            f = zrefClass.getDeclaredField("address");
            zRef_address_offset = u.objectFieldOffset(f);
            MethodHandles.Lookup l = UnsafeUtil.lookup();
            boolean newInflate = true;
            try {
                inflate = l.findVirtual(Inflater.class, "inflateBytesBytes", MethodType.methodType(Long.TYPE, Long.TYPE, byte[].class, Integer.TYPE, Integer.TYPE, byte[].class, Integer.TYPE, Integer.TYPE));
            }
            catch (NoSuchMethodException ignored) {
                newInflate = false;
                inflate = null;
            }
            NEW_INFLATE = newInflate;
            INFLATE = inflate;
            MH_RESET = l.findStatic(Inflater.class, "reset", MethodType.methodType(Void.TYPE, Long.TYPE));
            MH_FINISHED = l.findSetter(Inflater.class, "finished", Boolean.TYPE);
        }
        catch (ReflectiveOperationException ex) {
            throw new ExceptionInInitializerError(ex);
        }
    }
}

