/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util.data;

import java.lang.foreign.MemorySegment;
import javax.annotation.Nonnull;
import software.coley.lljzip.util.MemorySegmentUtil;

public interface MemorySegmentData {
    @Nonnull
    public MemorySegment get();

    default public long length() {
        return this.get().byteSize();
    }

    @Nonnull
    default public MemorySegmentData copy() {
        return MemorySegmentData.of(this.get());
    }

    @Nonnull
    public static MemorySegmentData empty() {
        return EmptySegment.INSTANCE;
    }

    @Nonnull
    public static MemorySegmentData of(@Nonnull byte[] source) {
        if (source.length == 0) {
            return MemorySegmentData.empty();
        }
        return MemorySegmentData.of(MemorySegment.ofArray(source));
    }

    @Nonnull
    public static MemorySegmentData of(@Nonnull MemorySegment segment) {
        if (segment.byteSize() == 0L) {
            return MemorySegmentData.empty();
        }
        return new FullSegment(segment);
    }

    @Nonnull
    public static MemorySegmentData of(@Nonnull MemorySegment segment, long offset, long length) {
        if (length == 0L) {
            return MemorySegmentData.empty();
        }
        return new Caching(new PartialSegment(segment, offset, length));
    }

    public static class EmptySegment
    implements MemorySegmentData {
        private static final EmptySegment INSTANCE = new EmptySegment();

        private EmptySegment() {
        }

        @Override
        @Nonnull
        public MemorySegment get() {
            return MemorySegmentUtil.EMPTY;
        }
    }

    public static class FullSegment
    implements MemorySegmentData {
        private final MemorySegment segment;

        public FullSegment(@Nonnull MemorySegment segment) {
            this.segment = segment;
        }

        @Override
        @Nonnull
        public MemorySegment get() {
            return this.segment;
        }

        @Override
        @Nonnull
        public MemorySegmentData copy() {
            return this;
        }
    }

    public static class Caching
    implements MemorySegmentData {
        private final MemorySegmentData delegate;
        private MemorySegment cached;

        public Caching(@Nonnull MemorySegmentData delegate) {
            this.delegate = delegate;
        }

        @Override
        @Nonnull
        public MemorySegment get() {
            if (this.cached == null) {
                this.cached = this.delegate.get();
            }
            return this.cached;
        }
    }

    public static class PartialSegment
    implements MemorySegmentData {
        private final MemorySegment segment;
        private final long offset;
        private final long length;

        public PartialSegment(@Nonnull MemorySegment segment, long offset, long length) {
            this.segment = segment;
            this.offset = offset;
            this.length = length;
        }

        @Override
        @Nonnull
        public MemorySegment get() {
            return this.segment.asSlice(this.offset, this.length);
        }
    }
}

