/*
 * Decompiled with CFR 0.152.
 */
package software.coley.lljzip.util.data;

import java.lang.foreign.MemorySegment;
import javax.annotation.Nonnull;
import software.coley.lljzip.util.MemorySegmentUtil;

public interface StringData {
    @Nonnull
    public String get();

    @Nonnull
    default public StringData substring(int begin, int end) {
        return StringData.of(this.get().substring(begin, end));
    }

    @Nonnull
    default public StringData copy() {
        return StringData.of(this.get());
    }

    @Nonnull
    public static StringData empty() {
        return Empty.INSTANCE;
    }

    @Nonnull
    public static StringData of(@Nonnull String source) {
        if (source.isEmpty()) {
            return StringData.empty();
        }
        return new Literal(source);
    }

    @Nonnull
    public static StringData of(@Nonnull MemorySegment segment) {
        if (segment.byteSize() == 0L) {
            return StringData.empty();
        }
        return new Caching(new FullSegment(segment));
    }

    @Nonnull
    public static StringData of(@Nonnull MemorySegment segment, long offset, long length) {
        if (length == 0L) {
            return StringData.empty();
        }
        return new Caching(new PartialSegment(segment, offset, length));
    }

    public static class Empty
    implements StringData {
        private static final Empty INSTANCE = new Empty();

        private Empty() {
        }

        @Override
        @Nonnull
        public String get() {
            return "";
        }
    }

    public static class Literal
    implements StringData {
        private final String content;

        public Literal(@Nonnull String content) {
            this.content = content;
        }

        @Override
        @Nonnull
        public String get() {
            return this.content;
        }

        @Override
        @Nonnull
        public StringData copy() {
            return this;
        }
    }

    public static class Caching
    implements StringData {
        private final StringData delegate;
        private String cached;

        public Caching(@Nonnull StringData delegate) {
            this.delegate = delegate;
        }

        @Override
        @Nonnull
        public String get() {
            if (this.cached == null) {
                this.cached = this.delegate.get();
            }
            return this.cached;
        }
    }

    public static class FullSegment
    implements StringData {
        private final MemorySegment segment;

        public FullSegment(@Nonnull MemorySegment segment) {
            this.segment = segment;
        }

        @Override
        @Nonnull
        public String get() {
            return MemorySegmentUtil.toString(this.segment);
        }
    }

    public static class PartialSegment
    implements StringData {
        private final MemorySegment segment;
        private final long offset;
        private final long length;

        public PartialSegment(@Nonnull MemorySegment segment, long offset, long length) {
            this.segment = segment;
            this.offset = offset;
            this.length = length;
        }

        @Override
        @Nonnull
        public String get() {
            return MemorySegmentUtil.readString(this.segment, this.offset, this.length);
        }
    }
}

