/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.BinaryExpressionModel;
import software.coley.sourcesolver.util.Range;

public class BinaryMapper
implements Mapper<BinaryExpressionModel, BinaryTree> {
    @Override
    @Nonnull
    public BinaryExpressionModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull BinaryTree tree) {
        Range range = Range.extractRange(table, tree);
        AbstractExpressionModel left = (AbstractExpressionModel)context.map(ExpressionMapper.class, tree.getLeftOperand());
        AbstractExpressionModel right = (AbstractExpressionModel)context.map(ExpressionMapper.class, tree.getRightOperand());
        BinaryExpressionModel.Operator operator = switch (tree.getKind()) {
            case Tree.Kind.PLUS -> BinaryExpressionModel.Operator.PLUS;
            case Tree.Kind.MINUS -> BinaryExpressionModel.Operator.MINUS;
            case Tree.Kind.MULTIPLY -> BinaryExpressionModel.Operator.MULTIPLY;
            case Tree.Kind.DIVIDE -> BinaryExpressionModel.Operator.DIVIDE;
            case Tree.Kind.REMAINDER -> BinaryExpressionModel.Operator.REMAINDER;
            case Tree.Kind.EQUAL_TO -> BinaryExpressionModel.Operator.EQUALS;
            case Tree.Kind.NOT_EQUAL_TO -> BinaryExpressionModel.Operator.NOT_EQUALS;
            case Tree.Kind.OR -> BinaryExpressionModel.Operator.BIT_OR;
            case Tree.Kind.AND -> BinaryExpressionModel.Operator.BIT_AND;
            case Tree.Kind.XOR -> BinaryExpressionModel.Operator.BIT_XOR;
            case Tree.Kind.CONDITIONAL_OR -> BinaryExpressionModel.Operator.CONDITIONAL_OR;
            case Tree.Kind.CONDITIONAL_AND -> BinaryExpressionModel.Operator.CONDITIONAL_AND;
            case Tree.Kind.LEFT_SHIFT -> BinaryExpressionModel.Operator.SHIFT_LEFT;
            case Tree.Kind.RIGHT_SHIFT -> BinaryExpressionModel.Operator.SHIFT_RIGHT;
            case Tree.Kind.UNSIGNED_RIGHT_SHIFT -> BinaryExpressionModel.Operator.SHIFT_RIGHT_UNSIGNED;
            case Tree.Kind.LESS_THAN -> BinaryExpressionModel.Operator.RELATION_LESS;
            case Tree.Kind.LESS_THAN_EQUAL -> BinaryExpressionModel.Operator.RELATION_LESS_EQUAL;
            case Tree.Kind.GREATER_THAN -> BinaryExpressionModel.Operator.RELATION_GREATER;
            case Tree.Kind.GREATER_THAN_EQUAL -> BinaryExpressionModel.Operator.RELATION_GREATER_EQUAL;
            case Tree.Kind.INSTANCE_OF -> BinaryExpressionModel.Operator.RELATION_INSTANCEOF;
            default -> BinaryExpressionModel.Operator.UNKNOWN;
        };
        return new BinaryExpressionModel(range, left, right, operator);
    }
}

