/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Name;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.MethodMapper;
import software.coley.sourcesolver.mapping.ModifiersMapper;
import software.coley.sourcesolver.mapping.NameMapper;
import software.coley.sourcesolver.mapping.StaticInitializerMethodMapper;
import software.coley.sourcesolver.mapping.TypeMapper;
import software.coley.sourcesolver.mapping.TypeParameterMapper;
import software.coley.sourcesolver.mapping.VariableMapper;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.ClassModel;
import software.coley.sourcesolver.model.ImplementsModel;
import software.coley.sourcesolver.model.MethodModel;
import software.coley.sourcesolver.model.ModifiersModel;
import software.coley.sourcesolver.model.NameExpressionModel;
import software.coley.sourcesolver.model.NamedModel;
import software.coley.sourcesolver.model.PermitsModel;
import software.coley.sourcesolver.model.TypeParameterModel;
import software.coley.sourcesolver.model.VariableModel;
import software.coley.sourcesolver.util.Range;

public class ClassMapper
implements Mapper<ClassModel, ClassTree> {
    @Override
    @Nonnull
    public ClassModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull ClassTree tree) {
        ModifiersMapper.ModifiersParsePair modifiersPair = (ModifiersMapper.ModifiersParsePair)context.map(ModifiersMapper.class, tree.getModifiers());
        List<AnnotationExpressionModel> annotationModels = modifiersPair.getAnnotations() == null ? Collections.emptyList() : modifiersPair.getAnnotations();
        ModifiersModel modifiersModel = modifiersPair.isEmpty() ? ModifiersModel.EMPTY : modifiersPair.getModifiers();
        Name className = tree.getSimpleName();
        List<? extends TypeParameterTree> typeParameters = tree.getTypeParameters();
        List<TypeParameterModel> typeParameterModels = typeParameters == null ? Collections.emptyList() : typeParameters.stream().map(t -> (TypeParameterModel)context.map(TypeParameterMapper.class, t)).toList();
        Tree extendsClause = tree.getExtendsClause();
        NamedModel extendsModel = extendsClause == null ? new NameExpressionModel(Range.UNKNOWN, "Object") : this.mapMaybeGeneric(context, extendsClause);
        List<? extends Tree> implementsClauses = tree.getImplementsClause();
        ImplementsModel implementsModel = implementsClauses.isEmpty() ? ImplementsModel.EMPTY : new ImplementsModel(Range.extractRange(table, implementsClauses), implementsClauses.stream().map(e -> this.mapMaybeGeneric(context, (Tree)e)).toList());
        List<? extends Tree> permitsClause = tree.getPermitsClause();
        PermitsModel permitsModel = permitsClause.isEmpty() ? PermitsModel.EMPTY : new PermitsModel(Range.extractRange(table, permitsClause), permitsClause.stream().map(e -> this.mapMaybeGeneric(context, (Tree)e)).toList());
        ArrayList<VariableModel> fieldModels = new ArrayList<VariableModel>();
        ArrayList<MethodModel> methodModels = new ArrayList<MethodModel>();
        ArrayList<ClassModel> innerClassModels = new ArrayList<ClassModel>();
        for (Tree tree2 : tree.getMembers()) {
            if (tree2 instanceof MethodTree) {
                MethodTree methodTree = (MethodTree)tree2;
                MethodModel methodModel = (MethodModel)context.map(MethodMapper.class, methodTree);
                methodModels.add(methodModel);
                continue;
            }
            if (tree2 instanceof VariableTree) {
                VariableTree variableTree = (VariableTree)tree2;
                VariableModel fieldModel = (VariableModel)context.map(VariableMapper.class, variableTree);
                fieldModels.add(fieldModel);
                continue;
            }
            if (tree2 instanceof ClassTree) {
                ClassTree innerClassTree = (ClassTree)tree2;
                ClassModel innerClassModel = this.map(context, table, innerClassTree);
                innerClassModels.add(innerClassModel);
                continue;
            }
            if (!(tree2 instanceof BlockTree)) continue;
            BlockTree staticInitializerTree = (BlockTree)tree2;
            methodModels.add((MethodModel)context.map(StaticInitializerMethodMapper.class, staticInitializerTree));
        }
        return new ClassModel(Range.extractRange(table, tree), annotationModels, modifiersModel, className.toString(), typeParameterModels, extendsModel, implementsModel, permitsModel, fieldModels, methodModels, innerClassModels);
    }

    @Nonnull
    private NamedModel mapMaybeGeneric(@Nonnull MappingContext context, @Nonnull Tree tree) {
        if (tree instanceof ParameterizedTypeTree) {
            ParameterizedTypeTree parameterizedType = (ParameterizedTypeTree)tree;
            return (NamedModel)context.map(TypeMapper.class, parameterizedType);
        }
        return (NamedModel)context.map(NameMapper.class, tree);
    }
}

