/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.PackageTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import software.coley.sourcesolver.mapping.AnnotationUseMapper;
import software.coley.sourcesolver.mapping.ClassMapper;
import software.coley.sourcesolver.mapping.ImportMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.PackageMapper;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.ClassModel;
import software.coley.sourcesolver.model.CompilationUnitModel;
import software.coley.sourcesolver.model.ImportModel;
import software.coley.sourcesolver.model.PackageModel;
import software.coley.sourcesolver.util.Range;

public class CompilationUnitMapper
implements Mapper<CompilationUnitModel, CompilationUnitTree> {
    private final String inputSource;

    public CompilationUnitMapper(@Nonnull String inputSource) {
        this.inputSource = inputSource;
    }

    @Override
    @Nonnull
    public CompilationUnitModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull CompilationUnitTree tree) {
        List packageAnnotations = tree.getPackageAnnotations() == null ? Collections.emptyList() : tree.getPackageAnnotations().stream().map(anno -> (AnnotationExpressionModel)context.map(AnnotationUseMapper.class, anno)).collect(Collectors.toList());
        context.setMapperSupplier(PackageMapper.class, () -> new PackageMapper(packageAnnotations));
        PackageTree packageDeclaration = tree.getPackage();
        PackageModel packageModel = packageDeclaration == null ? PackageModel.DEFAULT_PACKAGE : (PackageModel)context.map(PackageMapper.class, packageDeclaration);
        List<ImportModel> importModels = tree.getImports().stream().map(i -> (ImportModel)context.map(ImportMapper.class, i)).toList();
        List<ClassModel> classModels = tree.getTypeDecls().stream().filter(t -> t instanceof ClassTree).map(t -> (ClassTree)t).map(ct -> (ClassModel)context.map(ClassMapper.class, ct)).toList();
        return new CompilationUnitModel(Range.extractRange(table, tree), this.inputSource, packageModel, importModels, classModels);
    }
}

