/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ErroneousTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.List;
import software.coley.sourcesolver.mapping.AnnotationUseMapper;
import software.coley.sourcesolver.mapping.ArrayDeclarationMapper;
import software.coley.sourcesolver.mapping.BinaryMapper;
import software.coley.sourcesolver.mapping.CaseMapper;
import software.coley.sourcesolver.mapping.CastMapper;
import software.coley.sourcesolver.mapping.IdentifierMapper;
import software.coley.sourcesolver.mapping.InstanceofMapper;
import software.coley.sourcesolver.mapping.LambdaMapper;
import software.coley.sourcesolver.mapping.LiteralMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.MemberReferenceMapper;
import software.coley.sourcesolver.mapping.MemberSelectMapper;
import software.coley.sourcesolver.mapping.MethodInvocationMapper;
import software.coley.sourcesolver.mapping.NewClassMapper;
import software.coley.sourcesolver.mapping.UnaryMapper;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.ArrayAccessExpressionModel;
import software.coley.sourcesolver.model.AssignmentExpressionModel;
import software.coley.sourcesolver.model.CaseModel;
import software.coley.sourcesolver.model.ConditionalExpressionModel;
import software.coley.sourcesolver.model.ErroneousExpressionModel;
import software.coley.sourcesolver.model.ParenthesizedExpressionModel;
import software.coley.sourcesolver.model.SwitchExpressionModel;
import software.coley.sourcesolver.model.UnknownExpressionModel;
import software.coley.sourcesolver.util.Range;

public class ExpressionMapper
implements Mapper<AbstractExpressionModel, ExpressionTree> {
    @Override
    @Nonnull
    public AbstractExpressionModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull ExpressionTree tree) {
        Range range = Range.extractRange(table, tree);
        if (tree instanceof ParenthesizedTree) {
            ParenthesizedTree parenthesized = (ParenthesizedTree)tree;
            return new ParenthesizedExpressionModel(range, this.map(context, table, parenthesized.getExpression()));
        }
        if (tree instanceof LiteralTree) {
            LiteralTree literal = (LiteralTree)tree;
            return (AbstractExpressionModel)context.map(LiteralMapper.class, literal);
        }
        if (tree instanceof IdentifierTree) {
            IdentifierTree identifier = (IdentifierTree)tree;
            return (AbstractExpressionModel)context.map(IdentifierMapper.class, identifier);
        }
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree memberAccess = (MemberSelectTree)tree;
            return (AbstractExpressionModel)context.map(MemberSelectMapper.class, memberAccess);
        }
        if (tree instanceof MethodInvocationTree) {
            MethodInvocationTree methodInvoke = (MethodInvocationTree)tree;
            return (AbstractExpressionModel)context.map(MethodInvocationMapper.class, methodInvoke);
        }
        if (tree instanceof AssignmentTree) {
            AssignmentTree assignment = (AssignmentTree)tree;
            AbstractExpressionModel variable = this.map(context, table, assignment.getVariable());
            AbstractExpressionModel expression = this.map(context, table, assignment.getExpression());
            return new AssignmentExpressionModel(range, variable, expression, AssignmentExpressionModel.Operator.SET);
        }
        if (tree instanceof CompoundAssignmentTree) {
            CompoundAssignmentTree assignment = (CompoundAssignmentTree)tree;
            AbstractExpressionModel variable = this.map(context, table, assignment.getVariable());
            AbstractExpressionModel expression = this.map(context, table, assignment.getExpression());
            AssignmentExpressionModel.Operator operator = switch (tree.getKind()) {
                case Tree.Kind.PLUS_ASSIGNMENT -> AssignmentExpressionModel.Operator.PLUS;
                case Tree.Kind.MINUS_ASSIGNMENT -> AssignmentExpressionModel.Operator.MINUS;
                case Tree.Kind.MULTIPLY_ASSIGNMENT -> AssignmentExpressionModel.Operator.MULTIPLY;
                case Tree.Kind.DIVIDE_ASSIGNMENT -> AssignmentExpressionModel.Operator.DIVIDE;
                case Tree.Kind.REMAINDER_ASSIGNMENT -> AssignmentExpressionModel.Operator.REMAINDER;
                case Tree.Kind.OR_ASSIGNMENT -> AssignmentExpressionModel.Operator.BIT_OR;
                case Tree.Kind.AND_ASSIGNMENT -> AssignmentExpressionModel.Operator.BIT_AND;
                case Tree.Kind.XOR_ASSIGNMENT -> AssignmentExpressionModel.Operator.BIT_XOR;
                case Tree.Kind.LEFT_SHIFT_ASSIGNMENT -> AssignmentExpressionModel.Operator.SHIFT_LEFT;
                case Tree.Kind.RIGHT_SHIFT_ASSIGNMENT -> AssignmentExpressionModel.Operator.SHIFT_RIGHT;
                case Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT -> AssignmentExpressionModel.Operator.SHIFT_RIGHT_UNSIGNED;
                default -> AssignmentExpressionModel.Operator.UNKNOWN;
            };
            return new AssignmentExpressionModel(range, variable, expression, operator);
        }
        if (tree instanceof BinaryTree) {
            BinaryTree binary = (BinaryTree)tree;
            return (AbstractExpressionModel)context.map(BinaryMapper.class, binary);
        }
        if (tree instanceof UnaryTree) {
            UnaryTree unary = (UnaryTree)tree;
            return (AbstractExpressionModel)context.map(UnaryMapper.class, unary);
        }
        if (tree instanceof TypeCastTree) {
            TypeCastTree cast = (TypeCastTree)tree;
            return (AbstractExpressionModel)context.map(CastMapper.class, cast);
        }
        if (tree instanceof InstanceOfTree) {
            InstanceOfTree instanceCheck = (InstanceOfTree)tree;
            return (AbstractExpressionModel)context.map(InstanceofMapper.class, instanceCheck);
        }
        if (tree instanceof NewClassTree) {
            NewClassTree newClass = (NewClassTree)tree;
            return (AbstractExpressionModel)context.map(NewClassMapper.class, newClass);
        }
        if (tree instanceof ArrayAccessTree) {
            ArrayAccessTree arrayAccess = (ArrayAccessTree)tree;
            return new ArrayAccessExpressionModel(range, this.map(context, table, arrayAccess.getExpression()), this.map(context, table, arrayAccess.getIndex()));
        }
        if (tree instanceof ConditionalExpressionTree) {
            ConditionalExpressionTree conditional = (ConditionalExpressionTree)tree;
            return new ConditionalExpressionModel(range, this.map(context, table, conditional.getCondition()), this.map(context, table, conditional.getTrueExpression()), this.map(context, table, conditional.getFalseExpression()));
        }
        if (tree instanceof NewArrayTree) {
            NewArrayTree array = (NewArrayTree)tree;
            return (AbstractExpressionModel)context.map(ArrayDeclarationMapper.class, array);
        }
        if (tree instanceof LambdaExpressionTree) {
            LambdaExpressionTree lambda = (LambdaExpressionTree)tree;
            return (AbstractExpressionModel)context.map(LambdaMapper.class, lambda);
        }
        if (tree instanceof SwitchExpressionTree) {
            SwitchExpressionTree switchExpr = (SwitchExpressionTree)tree;
            AbstractExpressionModel expression = (AbstractExpressionModel)context.map(ExpressionMapper.class, switchExpr.getExpression());
            List<CaseModel> cases = switchExpr.getCases().stream().map(c -> (CaseModel)context.map(CaseMapper.class, c)).toList();
            return new SwitchExpressionModel(range, expression, cases);
        }
        if (tree instanceof MemberReferenceTree) {
            MemberReferenceTree memberReference = (MemberReferenceTree)tree;
            return (AbstractExpressionModel)context.map(MemberReferenceMapper.class, memberReference);
        }
        if (tree instanceof AnnotationTree) {
            AnnotationTree annotation = (AnnotationTree)tree;
            return (AbstractExpressionModel)context.map(AnnotationUseMapper.class, annotation);
        }
        if (tree instanceof ErroneousTree) {
            return new ErroneousExpressionModel(range, tree.toString());
        }
        return new UnknownExpressionModel(range, tree.toString());
    }
}

