/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.model.LiteralExpressionModel;
import software.coley.sourcesolver.util.Range;

public class LiteralMapper
implements Mapper<LiteralExpressionModel, LiteralTree> {
    @Override
    @Nonnull
    public LiteralExpressionModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull LiteralTree tree) {
        Object content = tree.getValue();
        LiteralExpressionModel.Kind kind = switch (tree.getKind()) {
            case Tree.Kind.INT_LITERAL -> LiteralExpressionModel.Kind.INT;
            case Tree.Kind.LONG_LITERAL -> LiteralExpressionModel.Kind.LONG;
            case Tree.Kind.FLOAT_LITERAL -> LiteralExpressionModel.Kind.FLOAT;
            case Tree.Kind.DOUBLE_LITERAL -> LiteralExpressionModel.Kind.DOUBLE;
            case Tree.Kind.BOOLEAN_LITERAL -> LiteralExpressionModel.Kind.BOOLEAN;
            case Tree.Kind.CHAR_LITERAL -> LiteralExpressionModel.Kind.CHAR;
            case Tree.Kind.STRING_LITERAL -> LiteralExpressionModel.Kind.STRING;
            case Tree.Kind.NULL_LITERAL -> LiteralExpressionModel.Kind.NULL;
            default -> LiteralExpressionModel.Kind.ERROR;
        };
        return new LiteralExpressionModel(Range.extractRange(table, tree), kind, content);
    }
}

