/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.ModifiersTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import software.coley.sourcesolver.mapping.AnnotationUseMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.model.AbstractModel;
import software.coley.sourcesolver.model.AnnotationExpressionModel;
import software.coley.sourcesolver.model.ModifiersModel;
import software.coley.sourcesolver.util.Range;

public class ModifiersMapper
implements Mapper<ModifiersParsePair, ModifiersTree> {
    @Override
    @Nonnull
    public ModifiersParsePair map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nullable ModifiersTree tree) {
        if (tree == null) {
            return new ModifiersParsePair(Collections.emptyList(), null);
        }
        List<AnnotationExpressionModel> annotationModels = tree.getAnnotations().stream().map(anno -> (AnnotationExpressionModel)context.map(AnnotationUseMapper.class, anno)).toList();
        Set<String> modifierNames = tree.getFlags().stream().map(m -> m.name().toLowerCase().replace('_', '-')).collect(Collectors.toUnmodifiableSet());
        return new ModifiersParsePair(annotationModels, new ModifiersModel(Range.extractRange(table, tree), (Collection<String>)modifierNames));
    }

    public static class ModifiersParsePair
    extends AbstractModel {
        private final List<AnnotationExpressionModel> annotations;
        private final ModifiersModel modifiers;

        public ModifiersParsePair(@Nullable List<AnnotationExpressionModel> annotations, @Nullable ModifiersModel modifiers) {
            super(Range.UNKNOWN);
            this.annotations = annotations;
            this.modifiers = modifiers;
        }

        @Nullable
        public List<AnnotationExpressionModel> getAnnotations() {
            return this.annotations;
        }

        @Nullable
        public ModifiersModel getModifiers() {
            return this.modifiers;
        }

        public boolean isEmpty() {
            return this.modifiers == null || this.modifiers.getModifiers().isEmpty();
        }

        @Override
        public boolean equals(Object o) {
            return o == this;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }
}

