/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.BindingPatternTree;
import com.sun.source.tree.DeconstructionPatternTree;
import com.sun.source.tree.PatternTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.List;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.VariableMapper;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AbstractPatternModel;
import software.coley.sourcesolver.model.BindingPatternModel;
import software.coley.sourcesolver.model.DeconstructionPatternModel;
import software.coley.sourcesolver.model.UnknownPatternModel;
import software.coley.sourcesolver.model.VariableModel;
import software.coley.sourcesolver.util.Range;

public class PatternMapper
implements Mapper<AbstractPatternModel, PatternTree> {
    @Override
    @Nonnull
    public AbstractPatternModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull PatternTree tree) {
        Range range = Range.extractRange(table, tree);
        if (tree instanceof BindingPatternTree) {
            BindingPatternTree bindingTree = (BindingPatternTree)tree;
            VariableModel variable = (VariableModel)context.map(VariableMapper.class, bindingTree.getVariable());
            return new BindingPatternModel(range, variable);
        }
        if (tree instanceof DeconstructionPatternTree) {
            DeconstructionPatternTree deconstructionTree = (DeconstructionPatternTree)tree;
            AbstractExpressionModel deconstructor = (AbstractExpressionModel)context.map(ExpressionMapper.class, deconstructionTree.getDeconstructor());
            List<AbstractPatternModel> nestedPatterns = deconstructionTree.getNestedPatterns().stream().map(p -> (AbstractPatternModel)context.map(PatternMapper.class, p)).toList();
            return new DeconstructionPatternModel(range, deconstructor, nestedPatterns);
        }
        return new UnknownPatternModel(range, tree.toString());
    }
}

