/*
 * Decompiled with CFR 0.152.
 */
package software.coley.sourcesolver.mapping;

import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.YieldTree;
import com.sun.tools.javac.tree.EndPosTable;
import jakarta.annotation.Nonnull;
import java.util.List;
import javax.lang.model.element.Name;
import software.coley.sourcesolver.mapping.BlockMapper;
import software.coley.sourcesolver.mapping.CaseMapper;
import software.coley.sourcesolver.mapping.ClassMapper;
import software.coley.sourcesolver.mapping.ExpressionMapper;
import software.coley.sourcesolver.mapping.Mapper;
import software.coley.sourcesolver.mapping.MappingContext;
import software.coley.sourcesolver.mapping.TryMapper;
import software.coley.sourcesolver.mapping.VariableMapper;
import software.coley.sourcesolver.model.AbstractExpressionModel;
import software.coley.sourcesolver.model.AbstractStatementModel;
import software.coley.sourcesolver.model.AssertStatementModel;
import software.coley.sourcesolver.model.BlockStatementModel;
import software.coley.sourcesolver.model.BreakStatementModel;
import software.coley.sourcesolver.model.CaseModel;
import software.coley.sourcesolver.model.ContinueStatementModel;
import software.coley.sourcesolver.model.DoWhileLoopStatementModel;
import software.coley.sourcesolver.model.EmptyStatementModel;
import software.coley.sourcesolver.model.EnhancedForLoopStatementModel;
import software.coley.sourcesolver.model.ErroneousExpressionStatementModel;
import software.coley.sourcesolver.model.ErroneousModel;
import software.coley.sourcesolver.model.ExpressionStatementModel;
import software.coley.sourcesolver.model.ForLoopStatementModel;
import software.coley.sourcesolver.model.IfStatementModel;
import software.coley.sourcesolver.model.LabeledStatementModel;
import software.coley.sourcesolver.model.ReturnStatementModel;
import software.coley.sourcesolver.model.SwitchStatementModel;
import software.coley.sourcesolver.model.SynchronizedStatementModel;
import software.coley.sourcesolver.model.ThrowStatementModel;
import software.coley.sourcesolver.model.UnknownStatementModel;
import software.coley.sourcesolver.model.VariableModel;
import software.coley.sourcesolver.model.WhileLoopStatementModel;
import software.coley.sourcesolver.model.YieldStatementModel;
import software.coley.sourcesolver.util.Range;

public class StatementMapper
implements Mapper<AbstractStatementModel, StatementTree> {
    @Override
    @Nonnull
    public AbstractStatementModel map(@Nonnull MappingContext context, @Nonnull EndPosTable table, @Nonnull StatementTree tree) {
        Range range = Range.extractRange(table, tree);
        if (tree instanceof AssertTree) {
            AssertTree assertTree = (AssertTree)tree;
            AbstractExpressionModel condition = (AbstractExpressionModel)context.map(ExpressionMapper.class, assertTree.getCondition());
            AbstractExpressionModel detail = assertTree.getDetail() == null ? null : (AbstractExpressionModel)context.map(ExpressionMapper.class, assertTree.getDetail());
            return new AssertStatementModel(range, condition, detail);
        }
        if (tree instanceof BlockTree) {
            BlockTree blockTree = (BlockTree)tree;
            return (AbstractStatementModel)context.map(BlockMapper.class, blockTree);
        }
        if (tree instanceof BreakTree) {
            BreakTree breakTree = (BreakTree)tree;
            Name targetLabel = breakTree.getLabel();
            return new BreakStatementModel(range, targetLabel == null ? null : targetLabel.toString());
        }
        if (tree instanceof ClassTree) {
            ClassTree classTree = (ClassTree)tree;
            return (AbstractStatementModel)context.map(ClassMapper.class, classTree);
        }
        if (tree instanceof ContinueTree) {
            ContinueTree continueTree = (ContinueTree)tree;
            Name targetLabel = continueTree.getLabel();
            return new ContinueStatementModel(range, targetLabel == null ? null : targetLabel.toString());
        }
        if (tree instanceof DoWhileLoopTree) {
            DoWhileLoopTree doWhileLoopTree = (DoWhileLoopTree)tree;
            AbstractExpressionModel condition = (AbstractExpressionModel)context.map(ExpressionMapper.class, doWhileLoopTree.getCondition());
            AbstractStatementModel statement = this.map(context, table, doWhileLoopTree.getStatement());
            return new DoWhileLoopStatementModel(range, condition, statement);
        }
        if (tree instanceof EmptyStatementTree) {
            return new EmptyStatementModel(range);
        }
        if (tree instanceof EnhancedForLoopTree) {
            EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)tree;
            VariableModel variable = (VariableModel)context.map(VariableMapper.class, enhancedForLoopTree.getVariable());
            AbstractExpressionModel expression = (AbstractExpressionModel)context.map(ExpressionMapper.class, enhancedForLoopTree.getExpression());
            AbstractStatementModel statement = this.map(context, table, enhancedForLoopTree.getStatement());
            return new EnhancedForLoopStatementModel(range, variable, expression, statement);
        }
        if (tree instanceof ExpressionStatementTree) {
            ExpressionStatementTree expressionStatementTree = (ExpressionStatementTree)tree;
            AbstractExpressionModel expression = (AbstractExpressionModel)context.map(ExpressionMapper.class, expressionStatementTree.getExpression());
            return expression instanceof ErroneousModel ? new ErroneousExpressionStatementModel(range, expression) : new ExpressionStatementModel(range, expression);
        }
        if (tree instanceof ForLoopTree) {
            ForLoopTree forLoopTree = (ForLoopTree)tree;
            List<AbstractStatementModel> initializerStatements = forLoopTree.getInitializer().stream().map(s -> this.map(context, table, (StatementTree)s)).toList();
            List<AbstractStatementModel> updateStatements = forLoopTree.getUpdate().stream().map(s -> this.map(context, table, (StatementTree)s)).toList();
            AbstractExpressionModel condition = (AbstractExpressionModel)context.map(ExpressionMapper.class, forLoopTree.getCondition());
            AbstractStatementModel statement = this.map(context, table, forLoopTree.getStatement());
            return new ForLoopStatementModel(range, initializerStatements, updateStatements, condition, statement);
        }
        if (tree instanceof IfTree) {
            IfTree ifTree = (IfTree)tree;
            AbstractExpressionModel condition = (AbstractExpressionModel)context.map(ExpressionMapper.class, ifTree.getCondition());
            AbstractStatementModel thenStatement = this.map(context, table, ifTree.getThenStatement());
            AbstractStatementModel elseStatement = ifTree.getElseStatement() == null ? null : this.map(context, table, ifTree.getElseStatement());
            return new IfStatementModel(range, condition, thenStatement, elseStatement);
        }
        if (tree instanceof LabeledStatementTree) {
            LabeledStatementTree labeledStatementTree = (LabeledStatementTree)tree;
            Name targetLabel = labeledStatementTree.getLabel();
            AbstractStatementModel statement = this.map(context, table, labeledStatementTree.getStatement());
            return new LabeledStatementModel(range, targetLabel == null ? null : targetLabel.toString(), statement);
        }
        if (tree instanceof ReturnTree) {
            ReturnTree returnTree = (ReturnTree)tree;
            AbstractExpressionModel expression = returnTree.getExpression() == null ? null : (AbstractExpressionModel)context.map(ExpressionMapper.class, returnTree.getExpression());
            return new ReturnStatementModel(range, expression);
        }
        if (tree instanceof SwitchTree) {
            SwitchTree switchTree = (SwitchTree)tree;
            AbstractExpressionModel expression = (AbstractExpressionModel)context.map(ExpressionMapper.class, switchTree.getExpression());
            List<CaseModel> cases = switchTree.getCases().stream().map(c -> (CaseModel)context.map(CaseMapper.class, c)).toList();
            return new SwitchStatementModel(range, expression, cases);
        }
        if (tree instanceof SynchronizedTree) {
            SynchronizedTree synchronizedTree = (SynchronizedTree)tree;
            return new SynchronizedStatementModel(range, (AbstractExpressionModel)context.map(ExpressionMapper.class, synchronizedTree.getExpression()), (BlockStatementModel)context.map(BlockMapper.class, synchronizedTree.getBlock()));
        }
        if (tree instanceof ThrowTree) {
            ThrowTree throwTree = (ThrowTree)tree;
            return new ThrowStatementModel(range, (AbstractExpressionModel)context.map(ExpressionMapper.class, throwTree.getExpression()));
        }
        if (tree instanceof TryTree) {
            TryTree tryTree = (TryTree)tree;
            return (AbstractStatementModel)context.map(TryMapper.class, tryTree);
        }
        if (tree instanceof VariableTree) {
            VariableTree variableTree = (VariableTree)tree;
            return (AbstractStatementModel)context.map(VariableMapper.class, variableTree);
        }
        if (tree instanceof WhileLoopTree) {
            WhileLoopTree whileLoopTree = (WhileLoopTree)tree;
            AbstractExpressionModel condition = (AbstractExpressionModel)context.map(ExpressionMapper.class, whileLoopTree.getCondition());
            AbstractStatementModel statement = this.map(context, table, whileLoopTree.getStatement());
            return new WhileLoopStatementModel(range, condition, statement);
        }
        if (tree instanceof YieldTree) {
            YieldTree yieldTree = (YieldTree)tree;
            return new YieldStatementModel(range, (AbstractExpressionModel)context.map(ExpressionMapper.class, yieldTree.getValue()));
        }
        return new UnknownStatementModel(Range.extractRange(table, tree), tree.toString());
    }
}

